/*
 * Decompiled with CFR 0.152.
 */
package org.bsdn.contact;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.net.util.Base64;
import org.bsdn.contact.PermissionDeniedException;

public class ContactGenerator {
    private static ContactGenerator SINGLETON;
    private String domain;
    private String username;
    private String password;
    private final HttpClient client = new HttpClient();
    private static final String CHARSET = "utf8";

    public static void main(String[] args) throws HttpException, IOException, PermissionDeniedException {
        ContactGenerator instance = ContactGenerator.getInstance();
        System.out.println(instance.getUser("pippo.lai"));
        System.out.println("=====");
        System.out.println(instance.getAll());
        System.out.println("=====");
        System.out.println(instance.getGroup("cn=auction-administrators,ou=applications,ou=groups,dc=bsdn,dc=org"));
    }

    public static final ContactGenerator getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new ContactGenerator();
        }
        return SINGLETON;
    }

    public synchronized String getAll() {
        return this.request("/contacts");
    }

    public synchronized String getUser(String nickname) {
        return this.request(String.format("/contacts/email/%s", nickname));
    }

    public synchronized String getGroup(String group) {
        return this.request(String.format("/contacts/group/%s", group));
    }

    private ContactGenerator() {
        Properties properties = new Properties();
        InputStream is = ContactGenerator.class.getClassLoader().getResourceAsStream("bsdn-contact-api.properties");
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Properties Not Found", e.getCause());
        }
        this.username = this.decode(properties.getProperty("username"));
        this.password = this.decode(properties.getProperty("password"));
        this.domain = this.decode(properties.getProperty("domain"));
    }

    private String encode(String input) {
        input = new String(Base64.encodeBase64((byte[])input.getBytes()));
        return this.reverse(input);
    }

    private String reverse(String input) {
        if (input == null) {
            return null;
        }
        Pattern p = Pattern.compile("^([^=]+)(=*)?$");
        Matcher m = p.matcher(input);
        if (m.matches()) {
            input = new StringBuffer(m.group(1)).reverse().toString() + m.group(2);
        }
        return input;
    }

    private String decode(String input) {
        Pattern p = Pattern.compile("^\"(.+)\"$");
        Matcher m = p.matcher(input);
        input = m.matches() ? m.group(1) : new String(Base64.decodeBase64((String)this.reverse(input)));
        return input;
    }

    private void login() {
        try {
            PostMethod post = new PostMethod(this.getUri("/j_spring_security_check"));
            String body = String.format("j_username=%s&j_password=%s", this.username, this.password);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(body, "application/x-www-form-urlencoded", CHARSET));
            System.out.println(this.client.executeMethod((HttpMethod)post));
        }
        catch (Exception e) {
            this.rethrow(e.getCause());
        }
    }

    private String request(String path) {
        GetMethod get = new GetMethod(this.getUri(path));
        String result = "";
        try {
            int code = this.client.executeMethod((HttpMethod)get);
            if (code == 403) {
                this.login();
                code = this.client.executeMethod((HttpMethod)get);
            }
            if (code >= 400) {
                this.rethrow(new Exception(code + ""));
            }
            result = new String(get.getResponseBody(), Charset.forName(CHARSET));
        }
        catch (Exception e) {
            this.rethrow(e.getCause());
        }
        return result;
    }

    private void rethrow(Throwable thrown) {
        throw new RuntimeException("\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfbBSDN", thrown);
    }

    private String getUri(String path) {
        return String.format("%s%s", this.domain, path);
    }
}

