package org.bsdn.contact;

import static java.lang.String.format;
import static java.lang.System.out;
import static java.nio.charset.Charset.forName;
import static java.util.regex.Pattern.compile;
import static org.apache.commons.net.util.Base64.decodeBase64;
import static org.apache.commons.net.util.Base64.encodeBase64;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/**
 * <blockquote>
 * 
 * <pre>
 * BSDNContactWriter writer = BSDNContactWriter.getInstance();
 * String contact = writer.getUser(String nickname);
 * VCard vcard = new net.sourceforge.cardme.engine.VCardEngine().parseMultiple(contact);
 * String contacts = riter.getAll();
 * VCard [] vcards = new net.sourceforge.cardme.engine.VCardEngine().parseMultiple(contact);
 * </pre>
 * 
 * </blockquote>
 * 
 */
public class ContactGenerator {

	private static ContactGenerator SINGLETON;
	private String domain;
	private String username;
	private String password;
	private final HttpClient client = new HttpClient();
	private static final String CHARSET = "utf8";

	public static void main(String[] args) throws HttpException, IOException,
			PermissionDeniedException {

		ContactGenerator instance = getInstance();
		System.out.println(instance.getUser("pippo.lai"));
		System.out.println("=====");
		System.out.println(instance.getAll());
		System.out.println("=====");
		out.println(instance
				.getGroup("cn=auction-administrators,ou=applications,ou=groups,dc=bsdn,dc=org"));
	}

	public static final ContactGenerator getInstance() {
		if (SINGLETON == null) {
			SINGLETON = new ContactGenerator();
		}
		return SINGLETON;
	}

	public synchronized String getAll() {
		return request("/contacts");
	}

	public synchronized String getUser(String nickname) {
		return request(format("/contacts/email/%s", nickname));
	}

	public synchronized String getGroup(String group) {
		return request(format("/contacts/group/%s", group));
	}

	private ContactGenerator() {
		Properties properties = new Properties();
		InputStream is = ContactGenerator.class.getClassLoader()
				.getResourceAsStream("bsdn-contact-api.properties");
		try {
			properties.load(is);
		} catch (IOException e) {
			throw new RuntimeException("Properties Not Found", e.getCause());
		}
		this.username = decode(properties.getProperty("username"));
		this.password = decode(properties.getProperty("password"));
		this.domain = decode(properties.getProperty("domain"));
	}

	private String encode(String input) {
		input = new String(encodeBase64(input.getBytes()));
		return reverse(input);
	}

	private String reverse(String input) {
		if (input == null) {
			return null;
		}
		Pattern p = Pattern.compile("^([^=]+)(=*)?$");
		Matcher m = p.matcher(input);
		if (m.matches()) {
			input = new StringBuffer(m.group(1)).reverse().toString()
					+ m.group(2);
		}
		return input;
	}

	private String decode(String input) {
		Pattern p = compile("^\"(.+)\"$");
		Matcher m = p.matcher(input);
		if (m.matches())
			input = m.group(1);
		else {
			input = new String(decodeBase64(reverse(input)));
		}
		return input;
	}

	private void login() {
		try {
			PostMethod post = new PostMethod(getUri("/j_spring_security_check"));
			String body = String.format("j_username=%s&j_password=%s",
					new Object[] { username, password });
			post.setRequestEntity(new StringRequestEntity(body,
					"application/x-www-form-urlencoded", CHARSET));
			System.out.println(this.client.executeMethod(post));
		} catch (Exception e) {
			rethrow(e.getCause());
		}
	}

	private String request(String path) {
		GetMethod get = new GetMethod(getUri(path));
		String result = "";
		try {
			int code = client.executeMethod(get);
			if (code == 403) {
				login();
				code = client.executeMethod(get);
			}
			if (code >= 400) {
				rethrow(new Exception(code + ""));
			}
			result = new String(get.getResponseBody(), forName(CHARSET));
		} catch (Exception e) {
			rethrow(e.getCause());
		}
		return result;
	}

	private void rethrow(Throwable thrown) {
		throw new RuntimeException("系统错误，请联系BSDN", thrown);
	}

	private String getUri(String path) {
		return String.format("%s%s", domain, path);
	}
}