/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.write;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import xyz.noark.core.exception.DataException;
import xyz.noark.core.exception.ExceptionHelper;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.accessor.DataAccessor;
import xyz.noark.orm.write.OperateType;
import xyz.noark.orm.write.impl.EntityOperate;

class AsyncWriteContainer
implements Runnable {
    private final Serializable groupId;
    private final DataAccessor dataAccessor;
    private final int batchOperateNum;
    private final ReentrantLock dataUpdateLock = new ReentrantLock();
    private final ReentrantLock dataFlushLock = new ReentrantLock();
    private final ScheduledFuture<?> future;
    private Map<String, EntityOperate<?>> entityOperates = new HashMap();
    private Map<String, EntityOperate<?>> flushOperates;

    AsyncWriteContainer(Serializable groupId, int saveInterval, ScheduledExecutorService scheduledExecutorService, DataAccessor dataAccessor, int batchOperateNum) {
        this.groupId = groupId;
        this.dataAccessor = dataAccessor;
        this.batchOperateNum = batchOperateNum;
        this.future = scheduledExecutorService.scheduleAtFixedRate(this, saveInterval, saveInterval, TimeUnit.SECONDS);
    }

    private <T> EntityOperate<T> getEntityOperate(EntityMapping<T> em, T entity) {
        String entityId = em.getPrimaryKey(entity);
        EntityOperate<Object> entityOperate = this.entityOperates.get(entityId);
        if (null == entityOperate) {
            entityOperate = new EntityOperate<T>(entityId, em);
            this.entityOperates.put(entityId, entityOperate);
        }
        return entityOperate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void insert(EntityMapping<T> em, T entity) {
        this.dataUpdateLock.lock();
        try {
            EntityOperate<T> entityOperate = this.getEntityOperate(em, entity);
            entityOperate.insert(entity);
        }
        finally {
            this.dataUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void update(EntityMapping<T> em, T entity) {
        this.dataUpdateLock.lock();
        try {
            EntityOperate<T> entityOperate = this.getEntityOperate(em, entity);
            entityOperate.update(entity);
        }
        finally {
            this.dataUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void delete(EntityMapping<T> em, T entity) {
        this.dataUpdateLock.lock();
        try {
            EntityOperate<T> entityOperate = this.getEntityOperate(em, entity);
            boolean deleted = entityOperate.delete(entity);
            if (deleted) {
                this.entityOperates.remove(entityOperate.getId());
            }
        }
        finally {
            this.dataUpdateLock.unlock();
        }
    }

    private Map<String, EntityOperate<?>> getNewUpdateData() {
        Map<String, EntityOperate<?>> updateData;
        if (this.entityOperates.isEmpty()) {
            return Collections.emptyMap();
        }
        this.dataUpdateLock.lock();
        try {
            updateData = this.entityOperates;
            this.entityOperates = new HashMap(32);
        }
        finally {
            this.dataUpdateLock.unlock();
        }
        return updateData;
    }

    private void mergeFlushData(Map<String, EntityOperate<?>> updateData) {
        if (this.flushOperates == null) {
            this.flushOperates = updateData;
        } else {
            for (Map.Entry<String, EntityOperate<?>> e : updateData.entrySet()) {
                String id = e.getKey();
                EntityOperate<?> existOperate = e.getValue();
                this.flushOperates.put(id, existOperate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void syncFlush() {
        block12: {
            this.dataFlushLock.lock();
            try {
                Map<String, EntityOperate<?>> updateData = this.getNewUpdateData();
                this.mergeFlushData(updateData);
                if (this.flushOperates == null) break block12;
                try {
                    if (!this.flushOperates.isEmpty()) {
                        LogHelper.logger.info("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e\uff0cgroupId={}", new Object[]{this.groupId});
                        HashMap<EntityMapping, EnumMap> grouping = new HashMap<EntityMapping, EnumMap>(256);
                        Iterator<Object> iterator = this.flushOperates.values().iterator();
                        while (iterator.hasNext()) {
                            EntityOperate<?> entityOperate;
                            EntityOperate<?> op = entityOperate = iterator.next();
                            EnumMap category = grouping.computeIfAbsent(op.getEntityMapping(), key -> new EnumMap(OperateType.class));
                            if (op.isDelete()) {
                                category.computeIfAbsent(OperateType.DELETE, key -> new LinkedList()).add(op.getEntity());
                                continue;
                            }
                            if (op.isInsert()) {
                                category.computeIfAbsent(OperateType.INSERT, key -> new LinkedList()).add(op.getEntity());
                                continue;
                            }
                            if (op.isUpdate()) {
                                category.computeIfAbsent(OperateType.UPDATE, key -> new LinkedList()).add(op.getEntity());
                                continue;
                            }
                            throw new DataException("\u672a\u77e5\u7684\u64cd\u4f5c\u5b9e\u73b0...");
                        }
                        for (Map.Entry entry : grouping.entrySet()) {
                            this.autoOperateEntity(OperateType.DELETE, (EntityMapping)entry.getKey(), (EnumMap)entry.getValue());
                            this.autoOperateEntity(OperateType.UPDATE, (EntityMapping)entry.getKey(), (EnumMap)entry.getValue());
                            this.autoOperateEntity(OperateType.INSERT, (EntityMapping)entry.getKey(), (EnumMap)entry.getValue());
                        }
                        LogHelper.logger.info("\u4fdd\u5b58\u6570\u636e\u5b8c\u6210\uff0cgroupId={}", new Object[]{this.groupId});
                    }
                }
                finally {
                    this.flushOperates = null;
                }
            }
            finally {
                this.dataFlushLock.unlock();
            }
        }
    }

    private <T> void autoOperateEntity(OperateType type, EntityMapping<T> em, EnumMap<OperateType, List<T>> entityMap) {
        List entityList = entityMap.getOrDefault((Object)type, Collections.emptyList());
        if (entityList.isEmpty()) {
            return;
        }
        if (entityList.size() == 1) {
            this.operateEntity(type, em, entityList.get(0));
            return;
        }
        if (entityList.size() > this.batchOperateNum) {
            entityList = new ArrayList(entityList);
        }
        int len = (entityList.size() - 1) / this.batchOperateNum + 1;
        for (int i = 0; i < len; ++i) {
            int start = i * this.batchOperateNum;
            int end = Math.min(start + this.batchOperateNum, entityList.size());
            this.batchOperateEntity(type, em, entityList.subList(start, end));
        }
    }

    private <T> void batchOperateEntity(OperateType type, EntityMapping<T> em, List<T> entityList) {
        try {
            switch (type) {
                case INSERT: {
                    this.dataAccessor.batchInsert(em, entityList);
                    break;
                }
                case DELETE: {
                    this.dataAccessor.batchDelete(em, entityList);
                    break;
                }
                case UPDATE: {
                    this.dataAccessor.batchUpdate(em, entityList);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogHelper.logger.debug("\u6279\u91cf\u5b58\u6863\u5931\u8d25\uff0c\u51c6\u5907\u9010\u6761\u5b58\u6863 e={}", new Object[]{e});
            ExceptionHelper.monitor((Throwable)e);
            for (T entity : entityList) {
                this.operateEntity(type, em, entity);
            }
        }
    }

    private <T> void operateEntity(OperateType type, EntityMapping<T> em, T entity) {
        try {
            switch (type) {
                case INSERT: {
                    this.dataAccessor.insert(em, entity);
                    break;
                }
                case DELETE: {
                    this.dataAccessor.delete(em, entity);
                    break;
                }
                case UPDATE: {
                    this.dataAccessor.update(em, entity);
                    break;
                }
            }
        }
        catch (Exception exx) {
            LogHelper.logger.error("\u64cd\u4f5c\u5b9e\u4f53\u65f6\u6570\u636e\u5f02\u5e38\uff0cgroupId={}{}", new Object[]{this.groupId, exx});
            LogHelper.logger.error("\u64cd\u4f5c\u5b9e\u4f53\u65f6\u7684\u5f02\u5e38\u6570\u636e entity={}", new Object[]{entity});
            ExceptionHelper.monitor((Throwable)exx);
        }
    }

    @Override
    public void run() {
        try {
            this.syncFlush();
        }
        catch (Throwable e) {
            LogHelper.logger.error("\u4fdd\u5b58\u4e2a\u4eba\u6570\u636e\u65f6\u5f02\u5e38\uff0cgroupId=" + this.groupId, new Object[]{e});
            ExceptionHelper.monitor((Throwable)e);
        }
    }

    public void close() {
        this.future.cancel(true);
    }
}

