/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.write;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.thread.NamedThreadFactory;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.accessor.DataAccessor;
import xyz.noark.orm.write.AsyncWriteContainer;
import xyz.noark.orm.write.AsyncWriteService;
import xyz.noark.orm.write.OperateType;

public abstract class AbstractAsyncWriteService
implements AsyncWriteService {
    private final int offlineInterval = 3600;
    @Autowired
    protected DataAccessor dataAccessor;
    @Value(value="data.save.interval")
    protected int saveInterval = 300;
    @Value(value="data.batch.num")
    protected int batchOperateNum = 256;
    protected ScheduledExecutorService scheduledExecutorService;
    @Value(value="data.thread.pool.size")
    private int threadPoolSize = 4;
    @Value(value="data.thread.name.prefix")
    private String threadNamePrefix = "async-write-data";
    private LoadingCache<Serializable, AsyncWriteContainer> containers;

    @Override
    public void init() {
        this.dataAccessor.judgeAccessType();
        LogHelper.logger.info("\u521d\u59cb\u5316\u6570\u636e\u5b58\u50a8\u6a21\u5757\uff0c\u6279\u91cf\u5b58\u6863\u6570\u91cf\u4e3a{},\u5b9a\u65f6\u5b58\u6863\u7684\u65f6\u95f4\u95f4\u9694\u4e3a{}\u79d2", new Object[]{this.batchOperateNum, this.saveInterval});
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(this.threadPoolSize, (ThreadFactory)new NamedThreadFactory(this.threadNamePrefix));
        RemovalListener<Serializable, AsyncWriteContainer> listener = new RemovalListener<Serializable, AsyncWriteContainer>(){

            public void onRemoval(Serializable key, AsyncWriteContainer value, RemovalCause cause) {
                LogHelper.logger.info("\u9500\u6bc1{}\u79d2\u90fd\u6ca1\u6709\u8bfb\u5199\u64cd\u4f5c\u7684\u5f02\u6b65\u56de\u5199\u5bb9\u5668 groupId={}", new Object[]{3600, key});
                value.syncFlush();
                value.close();
            }
        };
        CacheLoader<Serializable, AsyncWriteContainer> loader = new CacheLoader<Serializable, AsyncWriteContainer>(){

            public AsyncWriteContainer load(Serializable groupId) {
                LogHelper.logger.info("\u521b\u5efa\u5f02\u6b65\u56de\u5199\u5bb9\u5668 groupId={}", new Object[]{groupId});
                return new AsyncWriteContainer(groupId, AbstractAsyncWriteService.this.saveInterval, AbstractAsyncWriteService.this.scheduledExecutorService, AbstractAsyncWriteService.this.dataAccessor, AbstractAsyncWriteService.this.batchOperateNum);
            }
        };
        this.containers = Caffeine.newBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS).removalListener((RemovalListener)listener).build((CacheLoader)loader);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AbstractAsyncWriteService.this.containers.cleanUp();
            }
        }, 3600L, 3600L, TimeUnit.SECONDS);
    }

    @Override
    public <T> void insert(EntityMapping<T> em, T entity) {
        this.operation(em, entity, OperateType.INSERT);
    }

    @Override
    public <T> void delete(EntityMapping<T> em, T entity) {
        this.operation(em, entity, OperateType.DELETE);
    }

    @Override
    public <T> void deleteAll(EntityMapping<T> em, List<T> result) {
        for (T entity : result) {
            this.operation(em, entity, OperateType.DELETE);
        }
    }

    @Override
    public <T> void update(EntityMapping<T> em, T entity) {
        this.operation(em, entity, OperateType.UPDATE);
    }

    protected <T> void operation(EntityMapping<T> em, T entity, OperateType type) {
        Serializable groupId = this.analysisGroupIdByEntity(em, entity);
        AsyncWriteContainer container = (AsyncWriteContainer)this.containers.get((Object)groupId);
        switch (type) {
            case INSERT: {
                container.insert(em, entity);
                break;
            }
            case DELETE: {
                container.delete(em, entity);
                break;
            }
            case UPDATE: {
                container.update(em, entity);
                break;
            }
            default: {
                LogHelper.logger.warn("\u8fd9\u662f\u8981\u5e72\u561b\uff1f type={},entity={}", new Object[]{type, entity});
            }
        }
    }

    protected abstract <T> Serializable analysisGroupIdByEntity(EntityMapping<T> var1, T var2);

    @Override
    public void shutdown() {
        LogHelper.logger.info("\u5f00\u59cb\u901a\u77e5\u6570\u636e\u4fdd\u5b58\u4efb\u52a1\u7ebf\u7a0b\u6c60\u5173\u95ed.");
        this.syncFlushAll();
        this.scheduledExecutorService.shutdown();
        try {
            if (!this.scheduledExecutorService.awaitTermination(10L, TimeUnit.MINUTES)) {
                this.scheduledExecutorService.shutdownNow();
            }
            LogHelper.logger.info("\u6570\u636e\u4fdd\u5b58\u4efb\u52a1\u7ebf\u7a0b\u6c60\u5df2\u5168\u90e8\u56de\u5199\u5b8c\uff0c\u5173\u95ed\u6210\u529f.");
        }
        catch (InterruptedException ie) {
            LogHelper.logger.error("\u6570\u636e\u4fdd\u5b58\u4efb\u52a1\u7ebf\u7a0b\u6c60\u505c\u673a\u65f6\u53d1\u751f\u5f02\u5e38.", new Object[]{ie});
            this.scheduledExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void syncFlushAll() {
        for (AsyncWriteContainer container : this.containers.asMap().values()) {
            container.syncFlush();
        }
    }

    public void asyncFlushByGroupId(Serializable groupId) {
        AsyncWriteContainer container = (AsyncWriteContainer)this.containers.get((Object)groupId);
        if (container != null) {
            this.scheduledExecutorService.submit(container);
        }
    }
}

