/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.repository;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.orm.DataCheckAndInit;
import xyz.noark.orm.AnnotationEntityMaker;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.accessor.DataAccessor;

public class OrmRepository<T, K extends Serializable> {
    private static final AnnotationEntityMaker MAKER = new AnnotationEntityMaker();
    protected final EntityMapping<T> entityMapping;
    @Autowired
    protected DataAccessor dataAccessor;

    protected OrmRepository() {
        Type mySuperClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)mySuperClass).getActualTypeArguments()[0];
        this.entityMapping = MAKER.make((Class)type);
    }

    @DataCheckAndInit
    public void checkEntityAndInitCache() {
        this.dataAccessor.checkupEntityFieldsWithDatabase(this.entityMapping);
    }

    public void insert(T entity) {
        this.dataAccessor.insert(this.entityMapping, entity);
    }

    public void batchInsert(List<T> entitys) {
        this.dataAccessor.batchInsert(this.entityMapping, entitys);
    }

    public void delete(T entity) {
        this.dataAccessor.delete(this.entityMapping, entity);
    }

    public void batchDelete(List<T> entitys) {
        this.dataAccessor.batchDelete(this.entityMapping, entitys);
    }

    public void update(T entity) {
        this.dataAccessor.update(this.entityMapping, entity);
    }

    public void batchUpdate(List<T> entitys) {
        this.dataAccessor.batchUpdate(this.entityMapping, entitys);
    }

    public T load(K entityId) {
        return this.dataAccessor.load(this.entityMapping, entityId);
    }

    public List<T> loadAll() {
        return this.dataAccessor.loadAll(this.entityMapping);
    }

    public List<T> loadAll(Serializable playerId) {
        return this.dataAccessor.loadAll(this.entityMapping, playerId);
    }
}

