/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import xyz.noark.orm.cache.DataCache;
import xyz.noark.orm.cache.MultiDataCacheImpl;
import xyz.noark.orm.repository.AbstractCacheRepository;

public class MultiCacheRepository<T, K extends Serializable>
extends AbstractCacheRepository<T, K> {
    public void cacheDelete(Serializable playerId, K entityId) {
        Object result = this.dataCache.load(playerId, entityId);
        this.dataCache.delete(result);
        this.asyncWriteService.delete(this.entityMapping, result);
    }

    public void cacheDeleteAll(Serializable playerId) {
        List result = this.dataCache.deleteAll(playerId);
        this.asyncWriteService.deleteAll(this.entityMapping, result);
    }

    public Optional<T> cacheLoad(Serializable playerId, K entityId) {
        return Optional.ofNullable(this.dataCache.load(playerId, entityId));
    }

    public T cacheGet(Serializable playerId, K entityId) {
        return this.dataCache.load(playerId, entityId);
    }

    public T cacheGet(Serializable playerId, Predicate<T> filter) {
        return this.cacheLoad(playerId, filter).orElse(null);
    }

    public Optional<T> cacheLoad(Serializable playerId, Predicate<T> filter) {
        return Optional.ofNullable(this.dataCache.load(playerId, filter));
    }

    public long cacheCount(Serializable playerId, Predicate<T> filter) {
        return this.dataCache.count(playerId, filter);
    }

    public List<T> cacheLoadAll(Serializable playerId) {
        return this.dataCache.loadAll(playerId);
    }

    public List<T> cacheLoadAll(Serializable playerId, Predicate<T> filter) {
        return this.dataCache.loadAll(playerId, filter);
    }

    @Override
    protected DataCache<T, K> buildDataCache(int offlineInterval) {
        return new MultiDataCacheImpl(this, offlineInterval);
    }
}

