/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.repository;

import java.io.Serializable;
import java.util.List;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.annotation.orm.Entity;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.cache.DataCache;
import xyz.noark.orm.repository.CacheRepository;
import xyz.noark.orm.repository.OrmRepository;
import xyz.noark.orm.write.AsyncWriteService;

abstract class AbstractCacheRepository<T, K extends Serializable>
extends OrmRepository<T, K>
implements CacheRepository<T, K> {
    protected DataCache<T, K> dataCache;
    @Autowired
    protected AsyncWriteService asyncWriteService;
    @Value(value="data.offline.interval")
    private int offlineInterval = 3600;

    AbstractCacheRepository() {
    }

    @Override
    public EntityMapping<T> getEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public void checkEntityAndInitCache() {
        super.checkEntityAndInitCache();
        this.dataCache = this.buildDataCache(this.offlineInterval);
        if (this.entityMapping.getFetchType() == Entity.FetchType.START) {
            this.dataCache.initCacheData();
        }
    }

    protected abstract DataCache<T, K> buildDataCache(int var1);

    public void cacheInsert(T entity) {
        this.entityMapping.touchForCreate(entity);
        this.dataCache.insert(entity);
        this.asyncWriteService.insert(this.entityMapping, entity);
    }

    public void cacheDelete(T entity) {
        this.dataCache.delete(entity);
        this.asyncWriteService.delete(this.entityMapping, entity);
    }

    public void cacheDeleteAll() {
        List<T> result = this.dataCache.deleteAll();
        this.asyncWriteService.deleteAll(this.entityMapping, result);
    }

    public void cacheUpdate(T entity) {
        this.entityMapping.touchForUpdate(entity);
        this.dataCache.update(entity);
        this.asyncWriteService.update(this.entityMapping, entity);
    }

    public List<T> cacheLoadAll() {
        return this.dataCache.loadAll();
    }
}

