/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.emoji;

import java.util.HashMap;
import java.util.Map;
import xyz.noark.orm.emoji.EmojiConfig;
import xyz.noark.orm.emoji.EmojiLoader;
import xyz.noark.orm.emoji.EmojiNode;

public class EmojiManager {
    private static final Map<Character, EmojiNode> EMOJI_ROOT = new HashMap<Character, EmojiNode>(256);
    private static final Map<String, EmojiConfig> EMOJI_CONFIG_MAP = new HashMap<String, EmojiConfig>(2560);

    private static void initEmojiConfig(EmojiConfig config) {
        char[] array = config.getEmoji().toCharArray();
        EmojiNode fnode = EMOJI_ROOT.computeIfAbsent(Character.valueOf(array[0]), key -> new EmojiNode());
        int len = array.length;
        for (int i = 1; i < len; ++i) {
            fnode = fnode.addIfAbsent(Character.valueOf(array[i]));
        }
        fnode.setConfig(config);
    }

    public static String parseToAliases(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = null;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char temp;
            char cur = text.charAt(i);
            EmojiNode node = EMOJI_ROOT.get(Character.valueOf(cur));
            if (node == null) {
                if (sb == null) continue;
                sb.append(cur);
                continue;
            }
            EmojiNode backupsNode = node;
            boolean mark = false;
            int markIndex = -1;
            if (node.hasEmoji()) {
                mark = true;
                markIndex = i;
            }
            for (int k = i + 1; k < length && (node = backupsNode.querySub(Character.valueOf(temp = text.charAt(k)))) != null; ++k) {
                backupsNode = node;
                markIndex = k;
                if (!node.hasEmoji()) continue;
                mark = true;
            }
            if (mark) {
                if (sb == null) {
                    sb = new StringBuilder(length + 256);
                    if (i > 0) {
                        sb.append(text.substring(0, i));
                    }
                }
                sb.append(':').append(backupsNode.getAliases()).append(':');
                i = markIndex;
                continue;
            }
            if (sb == null) continue;
            sb.append(cur);
        }
        return sb == null ? text : sb.toString();
    }

    public static String parseToUnicode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = null;
        int startIndex = -1;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char cur = text.charAt(i);
            if (sb != null) {
                sb.append(cur);
            }
            if (cur == ':') {
                if (startIndex == -1) {
                    startIndex = i;
                    continue;
                }
                String aliases = text.substring(startIndex + 1, i);
                EmojiConfig config = EMOJI_CONFIG_MAP.get(aliases);
                if (config == null) {
                    startIndex = i;
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder(length);
                    if (startIndex > 0) {
                        sb.append(text.substring(0, startIndex));
                    }
                } else {
                    sb.setLength(sb.length() - aliases.length() - 2);
                }
                sb.append(config.getEmoji());
                startIndex = -1;
                continue;
            }
            if (startIndex < 0 || cur != ',' && cur != '\"') continue;
            startIndex = -1;
        }
        return sb == null ? text : sb.toString();
    }

    static {
        for (EmojiConfig config : EmojiLoader.loadAll(EmojiConfig.class)) {
            config.getAliases().forEach(v -> EMOJI_CONFIG_MAP.put((String)v, config));
            EmojiManager.initEmojiConfig(config);
        }
    }
}

