/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import xyz.noark.core.annotation.orm.Entity;
import xyz.noark.core.exception.DataException;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.cache.AbstractDataCache;
import xyz.noark.orm.repository.CacheRepository;

public class UniqueDataCacheImpl<T, K extends Serializable>
extends AbstractDataCache<T, K> {
    private final LoadingCache<K, DataWrapper<T>> caches;

    public UniqueDataCacheImpl(final CacheRepository<T, K> repository, long offlineInterval) {
        super(repository);
        CacheLoader loader = new CacheLoader<K, DataWrapper<T>>(){

            public DataWrapper<T> load(K entityId) throws Exception {
                if (UniqueDataCacheImpl.this.entityMapping.getFetchType() == Entity.FetchType.START) {
                    return new DataWrapper(null);
                }
                return new DataWrapper(repository.load(entityId));
            }
        };
        this.caches = this.entityMapping.getFetchType() == Entity.FetchType.START ? Caffeine.newBuilder().build(loader) : Caffeine.newBuilder().expireAfterAccess(offlineInterval, TimeUnit.SECONDS).build(loader);
    }

    @Override
    public void insert(T entity) {
        Object entityId = this.getPrimaryIdValue(entity);
        DataWrapper wrapper = (DataWrapper)this.caches.get(entityId);
        if (wrapper.getEntity() != null) {
            throw new DataException("\u63d2\u5165\u4e86\u91cd\u590dKey:" + entityId);
        }
        wrapper.setEntity(entity);
    }

    @Override
    public void delete(T entity) {
        this.delete((K)this.getPrimaryIdValue(entity));
    }

    @Override
    public List<T> deleteAll() {
        List<T> result = this.loadAll();
        this.caches.invalidateAll();
        return result;
    }

    @Override
    public void update(T entity) {
        Object entityId = this.getPrimaryIdValue(entity);
        DataWrapper wrapper = (DataWrapper)this.caches.get(entityId);
        if (wrapper.getEntity() == null) {
            throw new DataException("\u4fee\u6539\u4e86\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684Key:" + entityId);
        }
        wrapper.setEntity(entity);
    }

    @Override
    public T load(K entityId) {
        return (T)((DataWrapper)this.caches.get(entityId)).getEntity();
    }

    @Override
    public List<T> loadAll() {
        return this.loadAllByQueryFilter(null);
    }

    @Override
    public List<T> loadAll(Predicate<T> filter) {
        return this.loadAllByQueryFilter(filter);
    }

    private List<T> loadAllByQueryFilter(Predicate<T> filter) {
        this.assertEntityFetchTypeIsStart();
        ConcurrentMap map = this.caches.asMap();
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(map.size());
        for (Map.Entry e : map.entrySet()) {
            Object entity = ((DataWrapper)e.getValue()).getEntity();
            if (entity == null || filter != null && !filter.test(entity)) continue;
            result.add(entity);
        }
        return result;
    }

    @Override
    public T delete(K entityId) {
        DataWrapper wrapper = (DataWrapper)this.caches.get(entityId);
        if (wrapper.getEntity() == null) {
            throw new DataException("\u5220\u9664\u4e86\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684Key:" + entityId);
        }
        Object result = wrapper.getEntity();
        wrapper.setEntity(null);
        return (T)result;
    }

    @Override
    public long count() {
        this.assertEntityFetchTypeIsStart();
        long result = 0L;
        ConcurrentMap map = this.caches.asMap();
        for (Map.Entry e : map.entrySet()) {
            Object entity = ((DataWrapper)e.getValue()).getEntity();
            if (entity == null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void initCacheData() {
        LogHelper.logger.debug("\u5b9e\u4f53\u7c7b[{}]\u6293\u53d6\u7b56\u7565\u4e3a\u542f\u52a8\u670d\u52a1\u5668\u5c31\u52a0\u8f7d\u7f13\u5b58.", new Object[]{this.entityMapping.getEntityClass()});
        List result = this.repository.loadAll();
        result.stream().forEach(entity -> this.caches.put(this.getPrimaryIdValue(entity), new DataWrapper(entity)));
        LogHelper.logger.debug("\u5b9e\u4f53\u7c7b[{}]\u521d\u59cb\u5316\u7f13\u5b58\u5b8c\u6210,\u4e00\u5171 {} \u6761\u6570\u636e.", new Object[]{this.entityMapping.getEntityClass(), result.size()});
    }

    private class DataWrapper<E> {
        private E entity;

        private DataWrapper(E entity) {
            this.entity = entity;
        }

        E getEntity() {
            return this.entity;
        }

        void setEntity(E entity) {
            this.entity = entity;
        }
    }
}

