/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import xyz.noark.core.annotation.orm.Entity;
import xyz.noark.core.exception.DataException;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.cache.AbstractDataCache;
import xyz.noark.orm.repository.CacheRepository;

public class MultiDataCacheImpl<T, K extends Serializable>
extends AbstractDataCache<T, K> {
    private final LoadingCache<Serializable, ConcurrentMap<K, T>> caches;

    public MultiDataCacheImpl(final CacheRepository<T, K> repository, long offlineInterval) {
        super(repository);
        CacheLoader loader = new CacheLoader<Serializable, ConcurrentMap<K, T>>(){

            public ConcurrentHashMap<K, T> load(Serializable playerId) throws Exception {
                if (MultiDataCacheImpl.this.entityMapping.getFetchType() == Entity.FetchType.START) {
                    return new ConcurrentHashMap(16);
                }
                List result = repository.loadAll(playerId);
                int initSize = result.size() > 32 ? result.size() : 32;
                ConcurrentHashMap datas = new ConcurrentHashMap(initSize);
                for (Object entity : result) {
                    datas.put(MultiDataCacheImpl.this.getPrimaryIdValue(entity), entity);
                }
                return datas;
            }
        };
        this.caches = this.entityMapping.getFetchType() == Entity.FetchType.START ? Caffeine.newBuilder().build(loader) : Caffeine.newBuilder().expireAfterAccess(offlineInterval, TimeUnit.SECONDS).build(loader);
    }

    @Override
    public void insert(T entity) {
        Object entityId;
        Serializable playerId = this.entityMapping.getPlayerIdValue(entity);
        ConcurrentMap data = (ConcurrentMap)this.caches.get((Object)playerId);
        if (data.containsKey(entityId = this.getPrimaryIdValue(entity))) {
            throw new DataException("\u63d2\u5165\u4e86\u91cd\u590dKey:" + entityId);
        }
        data.put(entityId, entity);
    }

    @Override
    public void delete(T entity) {
        Object entityId;
        Serializable playerId = this.entityMapping.getPlayerIdValue(entity);
        ConcurrentMap data = (ConcurrentMap)this.caches.get((Object)playerId);
        Object result = data.remove(entityId = this.getPrimaryIdValue(entity));
        if (result == null) {
            throw new DataException("\u5220\u9664\u4e86\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684Key:" + entityId);
        }
    }

    @Override
    public List<T> deleteAll() {
        List<T> result = this.loadAll();
        this.caches.invalidateAll();
        return result;
    }

    @Override
    public List<T> deleteAll(Serializable playerId) {
        ConcurrentMap data = (ConcurrentMap)this.caches.get((Object)playerId);
        ArrayList result = new ArrayList(data.values());
        data.clear();
        return result;
    }

    @Override
    public void update(T entity) {
        Object entityId;
        Serializable playerId = this.entityMapping.getPlayerIdValue(entity);
        ConcurrentMap data = (ConcurrentMap)this.caches.get((Object)playerId);
        if (!data.containsKey(entityId = this.getPrimaryIdValue(entity))) {
            throw new DataException("\u4fee\u6539\u4e86\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684Key:" + entityId);
        }
        data.put(entityId, entity);
    }

    @Override
    public T load(Serializable playerId, K entityId) {
        return (T)((ConcurrentMap)this.caches.get((Object)playerId)).get(entityId);
    }

    @Override
    public T load(Serializable playerId, Predicate<T> filter) {
        return ((ConcurrentMap)this.caches.get((Object)playerId)).values().stream().filter(filter).findFirst().orElse(null);
    }

    @Override
    public long count(Serializable playerId, Predicate<T> filter) {
        return ((ConcurrentMap)this.caches.get((Object)playerId)).values().stream().filter(filter).count();
    }

    @Override
    public List<T> loadAll(Serializable playerId) {
        return new ArrayList(((ConcurrentMap)this.caches.get((Object)playerId)).values());
    }

    @Override
    public List<T> loadAll(Serializable playerId, Predicate<T> filter) {
        return ((ConcurrentMap)this.caches.get((Object)playerId)).values().stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public List<T> loadAll() {
        this.assertEntityFetchTypeIsStart();
        ConcurrentMap map = this.caches.asMap();
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(map.size());
        for (Map.Entry e : map.entrySet()) {
            result.addAll(((ConcurrentMap)e.getValue()).values());
        }
        return result;
    }

    @Override
    public List<T> loadAll(Predicate<T> filter) {
        this.assertEntityFetchTypeIsStart();
        ConcurrentMap map = this.caches.asMap();
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(map.size());
        for (Map.Entry e : map.entrySet()) {
            result.addAll(((ConcurrentMap)e.getValue()).values().stream().filter(filter).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public void initCacheData() {
        LogHelper.logger.debug("\u5b9e\u4f53\u7c7b[{}]\u6293\u53d6\u7b56\u7565\u4e3a\u542f\u52a8\u670d\u52a1\u5668\u5c31\u52a0\u8f7d\u7f13\u5b58.", new Object[]{this.entityMapping.getEntityClass()});
        List result = this.repository.loadAll();
        if (!result.isEmpty()) {
            HashMap data = new HashMap(result.size());
            for (Object entity : result) {
                Serializable playerId = this.entityMapping.getPlayerIdValue(entity);
                ConcurrentHashMap ds = (ConcurrentHashMap)data.get(playerId);
                if (ds == null) {
                    ds = new ConcurrentHashMap(result.size() * 2);
                    data.put(playerId, ds);
                }
                ds.put(this.getPrimaryIdValue(entity), entity);
            }
            this.caches.putAll(data);
        }
        LogHelper.logger.debug("\u5b9e\u4f53\u7c7b[{}]\u521d\u59cb\u5316\u7f13\u5b58\u5b8c\u6210,\u4e00\u5171 {} \u6761\u6570\u636e.", new Object[]{this.entityMapping.getEntityClass(), result.size()});
    }
}

