/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql.mysql.adaptor;

import java.sql.ResultSet;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.sql.PreparedStatementProxy;
import xyz.noark.orm.accessor.sql.mysql.adaptor.AbstractValueAdaptor;
import xyz.noark.orm.emoji.EmojiManager;

class StringAdaptor
extends AbstractValueAdaptor<String> {
    StringAdaptor() {
    }

    @Override
    protected void toPreparedStatement(FieldMapping fm, PreparedStatementProxy pstmt, String value, int parameterIndex) throws Exception {
        if (fm.isEmoji()) {
            value = EmojiManager.parseToAliases(value);
        }
        pstmt.setString(fm, parameterIndex, value);
    }

    @Override
    protected Object toParameter(FieldMapping fm, ResultSet rs) throws Exception {
        String value = rs.getString(fm.getColumnName());
        if (fm.isEmoji()) {
            value = EmojiManager.parseToUnicode(value);
        }
        return value;
    }
}

