/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql.mysql.adaptor;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.sql.PreparedStatementProxy;
import xyz.noark.orm.accessor.sql.mysql.adaptor.AbstractValueAdaptor;

class LocalDateTimeAdaptor
extends AbstractValueAdaptor<LocalDateTime> {
    LocalDateTimeAdaptor() {
    }

    @Override
    protected void toPreparedStatement(FieldMapping fm, PreparedStatementProxy pstmt, LocalDateTime value, int parameterIndex) throws Exception {
        if (value == null) {
            pstmt.setNull(parameterIndex, 93);
        } else {
            Date timestamp = Date.from(value.atZone(ZoneId.systemDefault()).toInstant());
            pstmt.setTimestamp(parameterIndex, new Timestamp(timestamp.getTime()));
        }
    }

    @Override
    protected Object toParameter(FieldMapping fm, ResultSet rs) throws Exception {
        Timestamp ts = rs.getTimestamp(fm.getColumnName());
        return null == ts ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneId.systemDefault());
    }
}

