/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql.mysql.adaptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.sql.PreparedStatementProxy;
import xyz.noark.orm.accessor.sql.mysql.adaptor.AbstractValueAdaptor;
import xyz.noark.orm.emoji.EmojiManager;

class JsonAdaptor
extends AbstractValueAdaptor<Object> {
    JsonAdaptor() {
    }

    @Override
    protected void toPreparedStatement(FieldMapping fm, PreparedStatementProxy pstmt, Object value, int parameterIndex) throws Exception {
        if (value == null) {
            pstmt.setString(fm, parameterIndex, null);
        } else {
            String json = JSON.toJSONString((Object)value);
            if (fm.isEmoji()) {
                json = EmojiManager.parseToAliases(json);
            }
            pstmt.setString(fm, parameterIndex, json);
        }
    }

    @Override
    protected Object toParameter(FieldMapping fm, ResultSet rs) throws Exception {
        String json = rs.getString(fm.getColumnName());
        if (fm.isEmoji()) {
            json = EmojiManager.parseToUnicode(json);
        }
        return JSON.parseObject((String)json, (Type)fm.getFieldClass(), (Feature[])new Feature[0]);
    }
}

