/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql.mysql;

import xyz.noark.core.util.StringUtils;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.FieldType;
import xyz.noark.orm.accessor.sql.AbstractSqlExpert;
import xyz.noark.orm.accessor.sql.mysql.MysqlKeyword;

public class MysqlSqlExpert
extends AbstractSqlExpert {
    @Override
    public <T> String genCreateTableSql(EntityMapping<T> em) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("CREATE TABLE `" + em.getTableName() + "` (");
        for (FieldMapping fm : em.getFieldMapping()) {
            sb.append('\n').append('`').append(fm.getColumnName()).append('`');
            sb.append(' ').append(this.evalFieldType(fm));
            this.buildCollate(sb, fm);
            if (fm.isPrimaryId()) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (fm.isNotNull()) {
                    sb.append(" NOT NULL");
                } else if (fm.getType() == FieldType.AsDate) {
                    sb.append(" NULL");
                }
                if (fm.hasDefaultValue()) {
                    switch (fm.getType()) {
                        case AsBoolean: 
                        case AsInteger: 
                        case AsAtomicInteger: 
                        case AsLong: 
                        case AsLongAdder: 
                        case AsAtomicLong: 
                        case AsFloat: 
                        case AsDouble: {
                            sb.append(" DEFAULT ").append(fm.getDefaultValue()).append("");
                            break;
                        }
                        default: {
                            if (fm.getWidth() >= 10240) break;
                            sb.append(" DEFAULT '").append(fm.getDefaultValue()).append("'");
                        }
                    }
                }
            }
            if (fm.hasColumnComment()) {
                sb.append(" COMMENT '").append(fm.getColumnComment()).append("'");
            }
            sb.append(',');
        }
        FieldMapping pk = em.getPrimaryId();
        if (pk != null) {
            sb.append('\n');
            sb.append("PRIMARY KEY (");
            sb.append('`').append(pk.getColumnName()).append('`').append(',');
            sb.setCharAt(sb.length() - 1, ')');
        }
        if (em.getPlayerId() != null && pk != null && !em.getPlayerId().getField().equals(pk.getField())) {
            sb.append(',').append('\n');
            sb.append("INDEX INDEX_UD (");
            sb.append('`').append(em.getPlayerId().getColumnName()).append('`').append(',');
            sb.setCharAt(sb.length() - 1, ')');
        }
        sb.append("\n )ENGINE=InnoDB DEFAULT CHARSET=utf8");
        if (!StringUtils.isEmpty((String)em.getTableComment())) {
            sb.append(" COMMENT='").append(em.getTableComment()).append("'");
        }
        return sb.append(";").toString();
    }

    private void buildCollate(StringBuilder sb, FieldMapping fm) {
        if (fm.hasCollate()) {
            sb.append(" COLLATE ").append(fm.getCollateValue());
        }
    }

    @Override
    protected String evalFieldType(FieldMapping fm) {
        switch (fm.getType()) {
            case AsInteger: 
            case AsAtomicInteger: {
                return "INT(11)";
            }
            case AsLong: 
            case AsLongAdder: 
            case AsAtomicLong: {
                return "BIGINT(20)";
            }
            case AsDouble: {
                return "DOUBLE(" + fm.getPrecision() + "," + fm.getScale() + ")";
            }
            case AsFloat: {
                return "FLOAT(" + fm.getPrecision() + "," + fm.getScale() + ")";
            }
        }
        return super.evalFieldType(fm);
    }

    @Override
    public <T> String genInsertSql(EntityMapping<T> em) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("INSERT INTO ");
        this.append(sb, em.getTableName()).append(" (");
        int count = 0;
        for (FieldMapping fm : em.getFieldMapping()) {
            this.append(sb, fm.getColumnName()).append(',');
            ++count;
        }
        sb.setCharAt(sb.length() - 1, ')');
        sb.append(" VALUES (");
        for (int i = 0; i < count; ++i) {
            sb.append("?,");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    @Override
    public <T> String genDeleteSql(EntityMapping<T> sem) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("DELETE FROM ");
        this.append(sb, sem.getTableName()).append(" WHERE ");
        this.append(sb, sem.getPrimaryId().getColumnName()).append("=?");
        return sb.toString();
    }

    @Override
    public <T> String genUpdateSql(EntityMapping<T> em) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("UPDATE ").append(em.getTableName()).append(" SET ");
        for (FieldMapping fm : em.getFieldMapping()) {
            if (fm.isPrimaryId()) continue;
            this.append(sb, fm.getColumnName()).append("=?,");
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("WHERE ");
        this.append(sb, em.getPrimaryId().getColumnName()).append("=?");
        return sb.toString();
    }

    @Override
    public <T> String genSelectByPlayerId(EntityMapping<T> em) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SELECT ");
        for (FieldMapping fm : em.getFieldMapping()) {
            this.append(sb, fm.getColumnName()).append(',');
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("FROM ");
        this.append(sb, em.getTableName());
        if (em.getPlayerId() != null) {
            sb.append(" WHERE ");
            this.append(sb, em.getPlayerId().getColumnName()).append("=?");
        }
        return sb.toString();
    }

    @Override
    public <T> String genSelectSql(EntityMapping<T> sem) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SELECT ");
        for (FieldMapping fm : sem.getFieldMapping()) {
            this.append(sb, fm.getColumnName()).append(',');
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("FROM ");
        this.append(sb, sem.getTableName());
        sb.append(" WHERE ");
        this.append(sb, sem.getPrimaryId().getColumnName()).append("=?");
        return sb.toString();
    }

    @Override
    public <T> String genSelectAllSql(EntityMapping<T> sem) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SELECT ");
        for (FieldMapping fm : sem.getFieldMapping()) {
            this.append(sb, fm.getColumnName()).append(',');
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("FROM ");
        return this.append(sb, sem.getTableName()).toString();
    }

    private <T> void handleSingleQuotationMarks(StringBuilder sb, EntityMapping<T> em, FieldMapping fm, T entity) {
        switch (fm.getType()) {
            case AsBoolean: 
            case AsInteger: 
            case AsAtomicInteger: 
            case AsLong: 
            case AsLongAdder: 
            case AsAtomicLong: 
            case AsFloat: 
            case AsDouble: {
                sb.append(em.getMethodAccess().invoke(entity, fm.getGetMethodIndex(), new Object[0]));
                break;
            }
            default: {
                sb.append("'").append(em.getMethodAccess().invoke(entity, fm.getGetMethodIndex(), new Object[0])).append("'");
            }
        }
    }

    @Override
    public <T> String genInsertSql(EntityMapping<T> em, T entity) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("INSERT DELAYED INTO ");
        this.append(sb, em.getTableName()).append(" (");
        for (FieldMapping fm : em.getFieldMapping()) {
            this.append(sb, fm.getColumnName()).append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        sb.append(" VALUES (");
        for (FieldMapping fm : em.getFieldMapping()) {
            this.handleSingleQuotationMarks(sb, em, fm, entity);
            sb.append(",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    @Override
    public <T> String genUpdateSql(EntityMapping<T> em, T entity) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("UPDATE ").append(em.getTableName()).append(" SET ");
        for (FieldMapping fm : em.getFieldMapping()) {
            if (fm.isPrimaryId()) continue;
            this.append(sb, fm.getColumnName()).append("=");
            this.handleSingleQuotationMarks(sb, em, fm, entity);
            sb.append(",");
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("WHERE ");
        this.append(sb, em.getPrimaryId().getColumnName()).append("=");
        this.handleSingleQuotationMarks(sb, em, em.getPrimaryId(), entity);
        return sb.toString();
    }

    @Override
    public <T> String genDeleteSql(EntityMapping<T> em, T entity) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("DELETE FROM ");
        this.append(sb, em.getTableName()).append(" WHERE ");
        this.append(sb, em.getPrimaryId().getColumnName()).append("=");
        this.handleSingleQuotationMarks(sb, em, em.getPrimaryId(), entity);
        return sb.toString();
    }

    @Override
    public <T> String genAddTableColumnSql(EntityMapping<T> em, FieldMapping fm) {
        return this.genAddOrUpdateTableColumnSql(em, fm, false);
    }

    @Override
    public <T> String genUpdateTableColumnSql(EntityMapping<T> em, FieldMapping fm) {
        return this.genAddOrUpdateTableColumnSql(em, fm, true);
    }

    private <T> String genAddOrUpdateTableColumnSql(EntityMapping<T> em, FieldMapping fm, boolean update) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ALTER TABLE `").append(em.getTableName()).append("` ").append(update ? "MODIFY" : "ADD").append(" COLUMN `").append(fm.getColumnName());
        sb.append("` ").append(this.evalFieldType(fm));
        this.buildCollate(sb, fm);
        if (fm.isNotNull()) {
            sb.append(" NOT NULL");
        } else if (fm.getType() == FieldType.AsDate) {
            sb.append(" NULL");
        }
        if (fm.hasDefaultValue()) {
            switch (fm.getType()) {
                case AsBoolean: 
                case AsInteger: 
                case AsAtomicInteger: 
                case AsLong: 
                case AsLongAdder: 
                case AsAtomicLong: 
                case AsFloat: 
                case AsDouble: {
                    sb.append(" DEFAULT ").append(fm.getDefaultValue()).append("");
                    break;
                }
                default: {
                    if (fm.getWidth() >= 10240) break;
                    sb.append(" DEFAULT '").append(fm.getDefaultValue()).append("'");
                }
            }
        }
        if (fm.hasColumnComment()) {
            sb.append(" COMMENT '").append(fm.getColumnComment()).append("'");
        }
        return sb.toString();
    }

    @Override
    public <T> String genDropTableColumnSql(EntityMapping<T> em, String columnName) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ALTER TABLE `").append(em.getTableName()).append("` DROP COLUMN `").append(columnName).append("` ");
        return sb.toString();
    }

    @Override
    public <T> String genUpdateDefaultValueSql(EntityMapping<T> em, FieldMapping fm) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("UPDATE ");
        this.append(sb, em.getTableName()).append(" SET ");
        this.append(sb, fm.getColumnName()).append("='").append(fm.getDefaultValue()).append("'");
        return sb.toString();
    }

    private StringBuilder append(StringBuilder sb, String name) {
        if (MysqlKeyword.isKeyword(name)) {
            return sb.append("`").append(name).append("`");
        }
        return sb.append(name);
    }
}

