/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql.mysql;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import xyz.noark.core.exception.DataException;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.sql.AbstractSqlDataAccessor;
import xyz.noark.orm.accessor.sql.PreparedStatementCallback;
import xyz.noark.orm.accessor.sql.PreparedStatementProxy;
import xyz.noark.orm.accessor.sql.mysql.MysqlSqlExpert;
import xyz.noark.orm.accessor.sql.mysql.adaptor.AbstractValueAdaptor;
import xyz.noark.orm.accessor.sql.mysql.adaptor.ValueAdaptorManager;

public class MysqlDataAccessor
extends AbstractSqlDataAccessor {
    public MysqlDataAccessor(DataSource dataSource) {
        super(new MysqlSqlExpert(), dataSource);
    }

    @Override
    protected void handleDataTooLongException(EntityMapping<?> em, Map<String, Integer> columnMaxLenMap) {
        this.executeStatement(stmt -> {
            try (ResultSet rs = stmt.executeQuery(StringUtils.join((String[])new String[]{"SELECT * FROM ", em.getTableName(), " LIMIT 0"}));){
                ResultSetMetaData rsmd = rs.getMetaData();
                int len = rsmd.getColumnCount();
                for (int i = 1; i <= len; ++i) {
                    int columnType = rsmd.getColumnType(i);
                    if (columnType != 12 && columnType != -1) continue;
                    String columnName = rsmd.getColumnName(i);
                    int max = rsmd.getColumnDisplaySize(i);
                    int length = columnMaxLenMap.getOrDefault(columnName, 0);
                    if (length <= max) continue;
                    em.getFieldMapping().stream().filter(v -> v.getColumnName().equals(columnName)).findFirst().ifPresent(fm -> {
                        int width = 0;
                        if (columnType == 12) {
                            width = length <= 512 ? length * 2 : length + 512;
                        } else if (columnType == -1) {
                            width = 65536;
                        }
                        if (width > 0) {
                            fm.setWidth(width);
                            LogHelper.logger.warn("\u667a\u80fd\u4fee\u6b63\u5b57\u6bb5\u957f\u5ea6 column={}, before={}, after={}", new Object[]{columnName, max, width});
                            this.autoAlterTableUpdateColumn(em, (FieldMapping)fm);
                        } else {
                            LogHelper.logger.error("\u53d1\u73b0\u4e86\u6269\u5bb9\u4e0d\u4e86\u60c5\u51b5\uff0c\u8bf7\u5206\u6790\u53c2\u6570 columnName={}, dbMax={}, length={}", new Object[]{columnName, max, length});
                        }
                    });
                }
            }
            return 0;
        });
    }

    @Override
    public <T> int insert(final EntityMapping<T> em, final T entity) {
        class InsertPreparedStatementCallback
        implements PreparedStatementCallback<Integer> {
            InsertPreparedStatementCallback() {
            }

            @Override
            public Integer doInPreparedStatement(PreparedStatementProxy pstmt) throws Exception {
                MysqlDataAccessor.this.buildInsertParameter(em, entity, pstmt);
                return pstmt.executeUpdate();
            }
        }
        return this.execute(em, new InsertPreparedStatementCallback(), this.expert.genInsertSql(em), true);
    }

    @Override
    public <T> int[] batchInsert(final EntityMapping<T> em, final List<T> entitys) {
        class InsertPreparedStatementCallback
        implements PreparedStatementCallback<int[]> {
            InsertPreparedStatementCallback() {
            }

            @Override
            public int[] doInPreparedStatement(PreparedStatementProxy pstmt) throws Exception {
                for (Object entity : entitys) {
                    MysqlDataAccessor.this.buildInsertParameter(em, entity, pstmt);
                    pstmt.addBatch();
                }
                return pstmt.executeBatch();
            }
        }
        return this.executeBatch(em, new InsertPreparedStatementCallback(), this.expert.genInsertSql(em), true);
    }

    private <T> void buildInsertParameter(EntityMapping<T> em, T entity, PreparedStatementProxy pstmt) throws Exception {
        int index = 1;
        for (FieldMapping fm : em.getFieldMapping()) {
            this.setPstmtParameter(em, fm, pstmt, entity, index++);
        }
    }

    @Override
    public <T> int delete(EntityMapping<T> em, T entity) {
        return this.delete(em, em.getPrimaryIdValue(entity));
    }

    private <K extends Serializable> int delete(EntityMapping<?> em, final K id) {
        class DeletePreparedStatementCallback
        implements PreparedStatementCallback<Integer> {
            DeletePreparedStatementCallback() {
            }

            @Override
            public Integer doInPreparedStatement(PreparedStatementProxy pstmt) throws SQLException {
                pstmt.setObject(1, id);
                return pstmt.executeUpdate();
            }
        }
        return this.execute(em, new DeletePreparedStatementCallback(), this.expert.genDeleteSql(em), true);
    }

    @Override
    public <T> int[] batchDelete(final EntityMapping<T> em, final List<T> entitys) {
        class DeletePreparedStatementCallback
        implements PreparedStatementCallback<int[]> {
            DeletePreparedStatementCallback() {
            }

            @Override
            public int[] doInPreparedStatement(PreparedStatementProxy pstmt) throws SQLException {
                for (Object entity : entitys) {
                    pstmt.setObject(1, em.getPrimaryIdValue(entity));
                    pstmt.addBatch();
                }
                return pstmt.executeBatch();
            }
        }
        return this.executeBatch(em, new DeletePreparedStatementCallback(), this.expert.genDeleteSql(em), true);
    }

    @Override
    public <T> int update(final EntityMapping<T> em, final T entity) {
        class UpdatePreparedStatementCallback
        implements PreparedStatementCallback<Integer> {
            UpdatePreparedStatementCallback() {
            }

            @Override
            public Integer doInPreparedStatement(PreparedStatementProxy pstmt) throws Exception {
                MysqlDataAccessor.this.buildUpdateParameter(em, entity, pstmt);
                return pstmt.executeUpdate();
            }
        }
        return this.execute(em, new UpdatePreparedStatementCallback(), this.expert.genUpdateSql(em), true);
    }

    @Override
    public <T> int[] batchUpdate(final EntityMapping<T> em, final List<T> entitys) {
        class UpdatePreparedStatementCallback
        implements PreparedStatementCallback<int[]> {
            UpdatePreparedStatementCallback() {
            }

            @Override
            public int[] doInPreparedStatement(PreparedStatementProxy pstmt) throws Exception {
                for (Object entity : entitys) {
                    MysqlDataAccessor.this.buildUpdateParameter(em, entity, pstmt);
                    pstmt.addBatch();
                }
                return pstmt.executeBatch();
            }
        }
        return this.executeBatch(em, new UpdatePreparedStatementCallback(), this.expert.genUpdateSql(em), true);
    }

    private <T> void buildUpdateParameter(EntityMapping<T> em, T entity, PreparedStatementProxy pstmt) throws Exception {
        int index = 1;
        for (FieldMapping fm : em.getFieldMapping()) {
            if (fm.isPrimaryId()) continue;
            this.setPstmtParameter(em, fm, pstmt, entity, index++);
        }
        this.setPstmtParameter(em, em.getPrimaryId(), pstmt, entity, index);
    }

    @Override
    public <T, K extends Serializable> T load(final EntityMapping<T> em, final K id) {
        class LoadPreparedStatementCallback
        implements PreparedStatementCallback<T> {
            LoadPreparedStatementCallback() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T doInPreparedStatement(PreparedStatementProxy pstmt) throws SQLException {
                pstmt.setObject(1, id);
                try (ResultSet rs = pstmt.executeQuery();){
                    Object t = rs.next() ? (Object)MysqlDataAccessor.this.newEntity(em, rs) : null;
                    return t;
                }
                catch (Exception e) {
                    throw new DataException("\u52a0\u8f7d\u6570\u636e\u65f6\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u5b9e\u4f53\u7c7b[" + em.getEntityClass().getName() + "]\u914d\u7f6e", (Throwable)e);
                }
            }
        }
        return this.execute(em, new LoadPreparedStatementCallback(), this.expert.genSelectSql(em), true);
    }

    @Override
    public <T> List<T> loadAll(final EntityMapping<T> em) {
        class LoadAllPreparedStatementCallback
        implements PreparedStatementCallback<List<T>> {
            LoadAllPreparedStatementCallback() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<T> doInPreparedStatement(PreparedStatementProxy pstmt) throws SQLException {
                try (ResultSet rs = pstmt.executeQuery();){
                    List list = MysqlDataAccessor.this.newEntityList(em, rs);
                    return list;
                }
                catch (Exception e) {
                    throw new DataException("\u52a0\u8f7d\u6570\u636e\u65f6\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u5b9e\u4f53\u7c7b[" + em.getEntityClass().getName() + "]\u914d\u7f6e", (Throwable)e);
                }
            }
        }
        return (List)this.execute(em, new LoadAllPreparedStatementCallback(), this.expert.genSelectAllSql(em), true);
    }

    public <T> List<T> newEntityList(EntityMapping<T> em, ResultSet rs) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            result.add(this.newEntity(em, rs));
        }
        return result;
    }

    public <T> T newEntity(EntityMapping<T> em, ResultSet rs) throws Exception {
        T result = em.newEntity();
        for (FieldMapping fm : em.getFieldInfo()) {
            ValueAdaptorManager.getValueAdaptor(fm.getType()).resultSetToParameter(em, fm, rs, result);
        }
        return result;
    }

    @Override
    public <T> List<T> loadAll(final EntityMapping<T> em, final Serializable playerId) {
        class LoadByPlayerIdIdPreparedStatementCallback
        implements PreparedStatementCallback<List<T>> {
            LoadByPlayerIdIdPreparedStatementCallback() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<T> doInPreparedStatement(PreparedStatementProxy pstmt) throws SQLException {
                pstmt.setObject(1, playerId);
                try (ResultSet rs = pstmt.executeQuery();){
                    List list = MysqlDataAccessor.this.newEntityList(em, rs);
                    return list;
                }
                catch (Exception e) {
                    throw new DataException("\u52a0\u8f7d\u6570\u636e\u65f6\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u5b9e\u4f53\u7c7b[" + em.getEntityClass().getName() + "]\u914d\u7f6e", (Throwable)e);
                }
            }
        }
        return (List)this.execute(em, new LoadByPlayerIdIdPreparedStatementCallback(), this.expert.genSelectByPlayerId(em), true);
    }

    private <T> void setPstmtParameter(EntityMapping<T> em, FieldMapping fm, PreparedStatementProxy pstmt, T entity, int index) throws Exception {
        AbstractValueAdaptor<T> adaptor = ValueAdaptorManager.getValueAdaptor(fm.getType());
        adaptor.parameterToPreparedStatement(em, fm, pstmt, entity, index);
    }
}

