/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import xyz.noark.orm.FieldMapping;

public class PreparedStatementProxy {
    private final PreparedStatement pstmt;
    private final boolean autoAlterColumnLength;
    private final boolean statementParameterSetLogEnable;
    private final List<List<Object>> batchParameterList = new LinkedList<List<Object>>();
    private final Map<String, Integer> columnMaxLenMap;
    private List<Object> parameters = new LinkedList<Object>();

    public PreparedStatementProxy(PreparedStatement pstmt, boolean statementParameterSetLogEnable, boolean autoAlterColumnLength, Map<String, Integer> columnMaxLenMap) {
        this.pstmt = pstmt;
        this.statementParameterSetLogEnable = statementParameterSetLogEnable;
        this.autoAlterColumnLength = autoAlterColumnLength;
        this.columnMaxLenMap = columnMaxLenMap;
    }

    public int executeUpdate() throws SQLException {
        return this.pstmt.executeUpdate();
    }

    public void addBatch() throws SQLException {
        this.pstmt.addBatch();
        this.batchParameterList.add(this.parameters);
        this.parameters = new LinkedList<Object>();
    }

    public int[] executeBatch() throws SQLException {
        return this.pstmt.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.pstmt.executeQuery();
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(x);
        }
        this.pstmt.setObject(parameterIndex, x);
    }

    public void setString(FieldMapping fm, int parameterIndex, String x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add("'" + x + "'");
        }
        this.pstmt.setString(parameterIndex, x);
        if (this.autoAlterColumnLength) {
            this.columnMaxLenMap.put(fm.getColumnName(), x == null ? 0 : x.length());
        }
    }

    public void setLong(int parameterIndex, Long x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(x);
        }
        this.pstmt.setLong(parameterIndex, x);
    }

    public void setInt(int parameterIndex, Integer x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(x);
        }
        this.pstmt.setInt(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, Boolean x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(x);
        }
        this.pstmt.setBoolean(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, Float x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(x);
        }
        this.pstmt.setFloat(parameterIndex, x.floatValue());
    }

    public void setDouble(int parameterIndex, Double x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(x);
        }
        this.pstmt.setDouble(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add(null);
        }
        this.pstmt.setNull(parameterIndex, sqlType);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.statementParameterSetLogEnable) {
            this.parameters.add("'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(x) + "'");
        }
        this.pstmt.setTimestamp(parameterIndex, x);
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public List<List<Object>> getBatchParameterList() {
        return this.batchParameterList;
    }
}

