/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql;

import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.sql.SqlExpert;

public abstract class AbstractSqlExpert
implements SqlExpert {
    protected String evalFieldType(FieldMapping fm) {
        switch (fm.getType()) {
            case AsBoolean: {
                return "BIT(1)";
            }
            case AsString: 
            case AsJson: {
                if (fm.getWidth() > 65535) {
                    return "MEDIUMTEXT";
                }
                if (fm.getWidth() >= 10240) {
                    return "TEXT";
                }
                return "VARCHAR(" + fm.getWidth() + ")";
            }
            case AsInstant: 
            case AsLocalDateTime: 
            case AsDate: {
                return "DATETIME";
            }
            case AsInteger: 
            case AsAtomicInteger: 
            case AsLong: 
            case AsLongAdder: 
            case AsAtomicLong: {
                if (fm.getWidth() > 0) {
                    return "INT(" + fm.getWidth() + ")";
                }
                return "INT";
            }
            case AsDouble: 
            case AsFloat: {
                if (fm.getWidth() > 0 && fm.getPrecision() > 0) {
                    return "NUMERIC(" + fm.getWidth() + "," + fm.getPrecision() + ")";
                }
                if (fm.isDouble()) {
                    return "NUMERIC(15,10)";
                }
                return "FLOAT";
            }
            case AsBlob: {
                return "BLOB";
            }
        }
        throw new UnrealizedException("\u672a\u5b9e\u73b0\u7684Java\u5c5e\u6027\u8f6cMysql\u7c7b\u578b\uff1a" + (Object)((Object)fm.getType()));
    }
}

