/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm.accessor.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.exception.DataException;
import xyz.noark.core.util.MathUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.AbstractDataAccessor;
import xyz.noark.orm.accessor.sql.Jdbcs;
import xyz.noark.orm.accessor.sql.PreparedStatementCallback;
import xyz.noark.orm.accessor.sql.PreparedStatementProxy;
import xyz.noark.orm.accessor.sql.SqlExpert;
import xyz.noark.orm.accessor.sql.StatementCallback;

public abstract class AbstractSqlDataAccessor
extends AbstractDataAccessor {
    private static final String MYSQL_DATA_TRUNCATION_CLASS_NAME = "com.mysql.jdbc.MysqlDataTruncation";
    private static final String MYSQL_DATA_INCORRECT_PREFIX = "Incorrect string value:";
    protected final SqlExpert expert;
    protected final DataSource dataSource;
    @Value(value="data.sql.log.enable")
    protected boolean statementExecutableSqlLogEnable = false;
    @Value(value="data.sql.log.parameter.enable")
    protected boolean statementParameterSetLogEnable = false;
    @Value(value="data.slow.query.sql.millis")
    protected int slowQuerySqlMillis = 0;
    @Value(value="data.auto.alter.column.length")
    protected boolean autoAlterColumnLength = true;
    @Value(value="data.auto.alter.emoji.column")
    protected boolean autoAlterEmojiColumn = true;
    @Value(value="data.auto.alter.table.drop.column")
    private boolean autoAlterTableDropColumn = false;

    public AbstractSqlDataAccessor(SqlExpert expert, DataSource dataSource) {
        this.expert = expert;
        this.dataSource = dataSource;
    }

    @Override
    public void judgeAccessType() {
        Jdbcs.judgeAccessType(this.dataSource);
    }

    public void setStatementExecutableSqlLogEnable(boolean statementExecutableSqlLogEnable) {
        this.statementExecutableSqlLogEnable = statementExecutableSqlLogEnable;
    }

    public void setStatementParameterSetLogEnable(boolean statementParameterSetLogEnable) {
        this.statementParameterSetLogEnable = statementParameterSetLogEnable;
    }

    public void setSlowQuerySqlMillis(int slowQuerySqlMillis) {
        this.slowQuerySqlMillis = slowQuerySqlMillis;
    }

    public void setAutoAlterTableDropColumn(boolean autoAlterTableDropColumn) {
        this.autoAlterTableDropColumn = autoAlterTableDropColumn;
    }

    /*
     * Exception decompiling
     */
    protected <T> T executeStatement(StatementCallback<T> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected <T> T execute(EntityMapping<?> em, PreparedStatementCallback<T> action, String sql, boolean flag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected <T> T executeBatch(EntityMapping<?> em, PreparedStatementCallback<T> action, String sql, boolean flag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryFixDataSaveException(boolean flag, EntityMapping<?> em, Map<String, Integer> columnMaxLenMap, Exception e) {
        if (flag && this.autoAlterColumnLength && MYSQL_DATA_TRUNCATION_CLASS_NAME.equals(e.getClass().getName())) {
            EntityMapping<?> entityMapping = em;
            synchronized (entityMapping) {
                this.handleDataTooLongException(em, columnMaxLenMap);
            }
            return true;
        }
        if (flag && this.autoAlterEmojiColumn && e instanceof SQLException && e.getMessage().startsWith(MYSQL_DATA_INCORRECT_PREFIX)) {
            EntityMapping<?> entityMapping = em;
            synchronized (entityMapping) {
                em.getFieldMapping().forEach(v -> v.setEmoji(true));
            }
            return true;
        }
        return false;
    }

    protected abstract void handleDataTooLongException(EntityMapping<?> var1, Map<String, Integer> var2);

    private void logExecutableSql(PreparedStatementProxy statement, String sql, long startTime, boolean isBatch) {
        float execTime;
        if (!this.statementExecutableSqlLogEnable) {
            return;
        }
        StringBuffer formattedSql = new StringBuffer(256);
        if (this.slowQuerySqlMillis > 0 && (execTime = (float)(System.nanoTime() - startTime) / 1000000.0f) >= (float)this.slowQuerySqlMillis) {
            formattedSql.append("exec sql ").append(MathUtils.formatScale((float)execTime, (int)2)).append(" ms.");
        }
        formattedSql.append("\n").append(this.statementParameterSetLogEnable ? sql.replaceAll("\\?", "{}") : sql);
        if (isBatch) {
            LogHelper.logger.debug("batch start...");
            if (statement.getBatchParameterList().isEmpty()) {
                LogHelper.logger.info(formattedSql.toString());
            } else {
                for (List<Object> parameters : statement.getBatchParameterList()) {
                    LogHelper.logger.info(formattedSql.toString(), parameters.toArray());
                }
            }
            LogHelper.logger.debug("batch end...");
        } else {
            LogHelper.logger.info(formattedSql.toString(), statement.getParameters().toArray());
        }
    }

    protected boolean exists(String tableName) {
        return this.executeStatement(stmt -> {
            String sql = "SELECT COUNT(1) FROM " + tableName + " where 1!=1";
            try (ResultSet rs = stmt.executeQuery(sql);){
                Boolean bl = rs.next();
                return bl;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public synchronized <T> void checkupEntityFieldsWithDatabase(EntityMapping<T> em) {
        if (this.exists(em.getTableName())) {
            this.checkEntityTable(em);
        } else {
            this.createEntityTable(em);
        }
    }

    private synchronized <T> void checkEntityTable(EntityMapping<T> em) {
        this.executeStatement(stmt -> {
            block19: {
                try (ResultSet rs = stmt.executeQuery(StringUtils.join((String[])new String[]{"SELECT * FROM ", em.getTableName(), " LIMIT 0"}));){
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int len = rsmd.getColumnCount();
                    HashMap<String, Integer> caches = new HashMap<String, Integer>(len);
                    for (int i = 1; i <= len; ++i) {
                        caches.put(rsmd.getColumnName(i), i);
                    }
                    for (FieldMapping fm : em.getFieldMapping()) {
                        Integer index;
                        if (!fm.getColumnName().equals(fm.getColumnName().toLowerCase())) {
                            LogHelper.logger.warn("\u5b57\u6bb5\u540d\u79f0\u4e2d\u6709\u5927\u5199\u5b57\u6bcd,\u5efa\u8bae\u4fee\u6b63\u4e3a\u4e0b\u5212\u7ebf\u547d\u540d\u65b9\u5f0f! entity={},field={},columnName={}", new Object[]{em.getEntityClass().getName(), fm.getField().getName(), fm.getColumnName()});
                        }
                        if ((index = (Integer)caches.remove(fm.getColumnName())) == null) {
                            this.autoAlterTableAddColumn(em, fm);
                            this.tryRepairTextDefaultValue(em, fm);
                            continue;
                        }
                        int columnType = rsmd.getColumnType(index);
                        if (columnType == 12) {
                            int length = rsmd.getColumnDisplaySize(index);
                            if (fm.getWidth() > length) {
                                this.autoAlterTableUpdateColumn(em, fm);
                                continue;
                            }
                            if (fm.getWidth() >= length) continue;
                            LogHelper.logger.warn("\u8868\u4e2d\u5b57\u6bb5\u957f\u5ea6\u5927\u4e8e\u914d\u7f6e\u957f\u5ea6\uff0c\u5efa\u8bae\u624b\u52a8\u4fee\u6b63! entity={},field={},length={}", new Object[]{em.getEntityClass().getName(), fm.getField().getName(), fm.getWidth()});
                            continue;
                        }
                        if (columnType != 4 || !fm.isLong()) continue;
                        this.autoAlterTableUpdateColumn(em, fm);
                    }
                    if (caches.isEmpty()) break block19;
                    if (this.autoAlterTableDropColumn) {
                        caches.keySet().forEach(key -> this.autoAlterTableDropColumn(em, (String)key));
                        break block19;
                    }
                    throw new DataException("\u8868\u7ed3\u6784\u5b57\u6bb5\u6bd4\u5b9e\u4f53\u7c7b\u5c5e\u6027\u591a. \u8868[" + em.getTableName() + "]\u4e2d\u7684\u5c5e\u6027\uff1a" + Arrays.toString(caches.keySet().toArray()));
                }
            }
            return 0;
        });
    }

    protected <T> void autoAlterTableUpdateColumn(EntityMapping<T> em, FieldMapping fm) {
        String sql = this.expert.genUpdateTableColumnSql(em, fm);
        LogHelper.logger.warn("\u5b9e\u4f53\u7c7b[{}]\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u51c6\u5907\u81ea\u52a8\u4fee\u8865\u8868\u7ed3\u6784\uff0cSQL\u5982\u4e0b:\n{}", new Object[]{em.getEntityClass(), sql});
        this.executeStatement(stmt -> stmt.executeUpdate(sql));
    }

    private <T> void tryRepairTextDefaultValue(EntityMapping<T> em, FieldMapping fm) {
        if (fm.getWidth() >= 10240 && fm.hasDefaultValue()) {
            String sql = this.expert.genUpdateDefaultValueSql(em, fm);
            LogHelper.logger.warn("\u5b9e\u4f53\u7c7b[{}]\u4e2d\u7684\u5b57\u6bb5[{}]\u4e0d\u652f\u6301\u9ed8\u8ba4\u503c\uff0c\u51c6\u5907\u81ea\u52a8\u4fee\u8865\u9ed8\u8ba4\u503c\uff0cSQL\u5982\u4e0b:\n{}", new Object[]{em.getEntityClass(), fm.getColumnName(), sql});
            this.executeStatement(stmt -> stmt.executeUpdate(sql));
        }
    }

    private <T> void autoAlterTableAddColumn(EntityMapping<T> em, FieldMapping fm) {
        String sql = this.expert.genAddTableColumnSql(em, fm);
        LogHelper.logger.warn("\u5b9e\u4f53\u7c7b[{}]\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u51c6\u5907\u81ea\u52a8\u4fee\u8865\u65b0\u589e\u7684\u5b57\u6bb5\uff0cSQL\u5982\u4e0b:\n{}", new Object[]{em.getEntityClass(), sql});
        this.executeStatement(stmt -> stmt.executeUpdate(sql));
    }

    private <T> void autoAlterTableDropColumn(EntityMapping<T> em, String columnName) {
        String sql = this.expert.genDropTableColumnSql(em, columnName);
        LogHelper.logger.warn("\u5b9e\u4f53\u7c7b[{}]\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u51c6\u5907\u81ea\u52a8\u5220\u9664\u591a\u4f59\u5b57\u6bb5\uff0cSQL\u5982\u4e0b:\n{}", new Object[]{em.getEntityClass(), sql});
        this.executeStatement(stmt -> stmt.executeUpdate(sql));
    }

    private synchronized <T> void createEntityTable(EntityMapping<T> em) {
        String sql = this.expert.genCreateTableSql(em);
        LogHelper.logger.warn("\u5b9e\u4f53\u7c7b[{}]\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u81ea\u52a8\u521b\u5efa\u8868\u7ed3\u6784\uff0cSQL\u5982\u4e0b:\n{}", new Object[]{em.getEntityClass(), sql});
        this.executeStatement(stmt -> stmt.executeUpdate(sql));
    }
}

