/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import xyz.noark.core.annotation.PlayerId;
import xyz.noark.core.annotation.orm.Blob;
import xyz.noark.core.annotation.orm.Collate;
import xyz.noark.core.annotation.orm.Column;
import xyz.noark.core.annotation.orm.CreatedDate;
import xyz.noark.core.annotation.orm.Emoji;
import xyz.noark.core.annotation.orm.Id;
import xyz.noark.core.annotation.orm.Json;
import xyz.noark.core.annotation.orm.LastModifiedDate;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.orm.accessor.FieldType;
import xyz.noark.reflectasm.MethodAccess;

public class FieldMapping {
    private final Field field;
    private final Type klass;
    private final Id id;
    private final Column column;
    private final PlayerId playerId;
    private final Json json;
    private final Collate collate;
    private final CreatedDate createdDate;
    private final LastModifiedDate lastModifiedDate;
    private final int getMethodIndex;
    private final int setMethodIndex;
    private FieldType type;
    private String columnName;
    private int width;
    private boolean emoji = false;

    public FieldMapping(Field field, MethodAccess methodAccess) {
        this.field = field;
        this.field.setAccessible(true);
        this.klass = field.getGenericType();
        this.id = field.getAnnotation(Id.class);
        this.column = field.getAnnotation(Column.class);
        this.collate = field.getAnnotation(Collate.class);
        this.playerId = field.getAnnotation(PlayerId.class);
        this.json = field.getAnnotation(Json.class);
        this.createdDate = field.getAnnotation(CreatedDate.class);
        this.lastModifiedDate = field.getAnnotation(LastModifiedDate.class);
        this.emoji = field.isAnnotationPresent(Emoji.class);
        this.getMethodIndex = methodAccess.getIndex(FieldUtils.genGetMethodName((Field)field));
        this.setMethodIndex = methodAccess.getIndex(FieldUtils.genSetMethodName((Field)field));
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldClass() {
        return this.klass;
    }

    public Column getColumn() {
        return this.column;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public FieldType getType() {
        return this.type;
    }

    void setType(FieldType type) {
        this.type = type;
    }

    public boolean isPrimaryId() {
        return this.id != null;
    }

    public boolean isPlayerId() {
        return this.playerId != null;
    }

    public int getPrecision() {
        return this.column == null ? 15 : this.column.precision();
    }

    public int getScale() {
        return this.column == null ? 5 : this.column.scale();
    }

    public boolean isNotNull() {
        return this.column != null && !this.column.nullable();
    }

    public boolean hasDefaultValue() {
        return this.column != null && !"".equals(this.column.defaultValue());
    }

    public String getDefaultValue() {
        return this.column.defaultValue();
    }

    public boolean hasColumnComment() {
        return !StringUtils.isEmpty((String)this.getColumnComment());
    }

    public String getColumnComment() {
        return this.column == null ? "" : this.column.comment();
    }

    public int getGetMethodIndex() {
        return this.getMethodIndex;
    }

    public int getSetMethodIndex() {
        return this.setMethodIndex;
    }

    public boolean hasCollate() {
        return this.collate != null;
    }

    public String getCollateValue() {
        return this.collate.value();
    }

    public boolean isString() {
        return String.class == this.klass;
    }

    public boolean isBoolean() {
        return this.klass == Boolean.TYPE || this.klass == Boolean.class;
    }

    public boolean isInt() {
        return this.klass == Integer.TYPE || this.klass == Integer.class;
    }

    public boolean isLong() {
        return this.klass == Long.TYPE || this.klass == Long.class;
    }

    public boolean isFloat() {
        return this.klass == Float.TYPE || this.klass == Float.class;
    }

    public boolean isDouble() {
        return this.klass == Double.TYPE || this.klass == Double.class;
    }

    public boolean isBlob() {
        return this.field.isAnnotationPresent(Blob.class) || this.klass == byte[].class;
    }

    public boolean isJson() {
        return this.json != null;
    }

    public boolean isCreatedDate() {
        return this.createdDate != null;
    }

    public boolean isLastModifiedDate() {
        return this.lastModifiedDate != null;
    }

    public boolean isEmoji() {
        return this.emoji;
    }

    public void setEmoji(boolean emoji) {
        this.emoji = emoji;
    }
}

