/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import xyz.noark.core.annotation.orm.Entity;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.FieldMapping;
import xyz.noark.reflectasm.ConstructorAccess;
import xyz.noark.reflectasm.MethodAccess;

public class EntityMapping<T> {
    protected final Class<T> klass;
    protected final Entity.FetchType fetchType;
    private final MethodAccess methodAccess;
    private final ConstructorAccess<T> constructorAccess;
    protected String tableName;
    protected FieldMapping primaryId;
    protected FieldMapping playerId;
    protected List<FieldMapping> fieldInfo;
    protected FieldMapping createdDate;
    protected FieldMapping lastModifiedDate;
    private String tableComment;

    public EntityMapping(Class<T> klass) {
        this.klass = klass;
        Entity entity = klass.getAnnotation(Entity.class);
        this.fetchType = entity.fetch();
        this.methodAccess = MethodAccess.get(klass);
        this.constructorAccess = ConstructorAccess.get(klass);
    }

    public Entity.FetchType getFetchType() {
        return this.fetchType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public FieldMapping getPrimaryId() {
        return this.primaryId;
    }

    public void setPrimaryId(FieldMapping primaryId) {
        this.primaryId = primaryId;
    }

    public FieldMapping getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(FieldMapping playerId) {
        this.playerId = playerId;
    }

    public List<FieldMapping> getFieldInfo() {
        return this.fieldInfo;
    }

    public void setFieldInfo(List<FieldMapping> fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public Serializable getPrimaryIdValue(Object entity) {
        return (Serializable)this.methodAccess.invoke(entity, this.primaryId.getGetMethodIndex(), new Object[0]);
    }

    public Serializable getPlayerIdValue(Object entity) {
        return (Serializable)this.methodAccess.invoke(entity, this.playerId.getGetMethodIndex(), new Object[0]);
    }

    public Class<T> getEntityClass() {
        return this.klass;
    }

    public List<FieldMapping> getFieldMapping() {
        return this.fieldInfo;
    }

    public void setCreatedDate(FieldMapping createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastModifiedDate(FieldMapping lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getPrimaryKey(Object entity) {
        return new StringBuilder(64).append(this.klass.getName()).append(':').append(this.getPrimaryIdValue(entity)).toString();
    }

    public T newEntity() {
        return (T)this.constructorAccess.newInstance();
    }

    public MethodAccess getMethodAccess() {
        return this.methodAccess;
    }

    public void touchForCreate(T entity) {
        if (this.createdDate != null && this.methodAccess.invoke(entity, this.createdDate.getGetMethodIndex(), new Object[0]) == null) {
            this.touchDate(entity, this.createdDate);
        }
        if (this.lastModifiedDate != null && this.methodAccess.invoke(entity, this.lastModifiedDate.getGetMethodIndex(), new Object[0]) == null) {
            this.touchDate(entity, this.lastModifiedDate);
        }
    }

    public void touchForUpdate(T entity) {
        if (this.lastModifiedDate != null) {
            this.touchDate(entity, this.lastModifiedDate);
        }
    }

    private void touchDate(T entity, FieldMapping fm) {
        switch (fm.getType()) {
            case AsDate: {
                this.methodAccess.invoke(entity, fm.getSetMethodIndex(), new Object[]{new Date()});
                break;
            }
            case AsInstant: {
                this.methodAccess.invoke(entity, fm.getSetMethodIndex(), new Object[]{Instant.now()});
                break;
            }
            case AsLocalDateTime: {
                this.methodAccess.invoke(entity, fm.getSetMethodIndex(), new Object[]{LocalDateTime.now()});
                break;
            }
            case AsLong: {
                this.methodAccess.invoke(entity, fm.getSetMethodIndex(), new Object[]{System.currentTimeMillis()});
                break;
            }
            default: {
                LogHelper.logger.warn("\u672a\u5b9e\u73b0\u7684\u7c7b\u578b type={}", new Object[]{fm.getType().name()});
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.klass == null ? 0 : this.klass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityMapping other = (EntityMapping)obj;
        return !(this.klass == null ? other.klass != null : !this.klass.equals(other.klass));
    }
}

