/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.orm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import xyz.noark.core.annotation.PlayerId;
import xyz.noark.core.annotation.orm.Column;
import xyz.noark.core.annotation.orm.Entity;
import xyz.noark.core.annotation.orm.Id;
import xyz.noark.core.annotation.orm.Table;
import xyz.noark.core.exception.NoEntityException;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.orm.DataModular;
import xyz.noark.orm.EntityMapping;
import xyz.noark.orm.FieldMapping;
import xyz.noark.orm.accessor.FieldType;
import xyz.noark.reflectasm.MethodAccess;

public class AnnotationEntityMaker {
    private static final HashSet<String> TABLE_NAME_SET = new HashSet(512);
    private static final List<Class<? extends Annotation>> ANNOTATIONS = new ArrayList<Class<? extends Annotation>>();

    public <T> EntityMapping<T> make(Class<T> klass) {
        if (!klass.isAnnotationPresent(Entity.class)) {
            throw new NoEntityException(klass.getName(), "\u6ca1\u6709@Entity\u6ce8\u89e3\u6807\u8bc6 \u2261 (^(OO)^) \u2261");
        }
        return this.makeEntity(klass);
    }

    private <T> EntityMapping<T> makeEntity(Class<T> klass) {
        EntityMapping<T> em = new EntityMapping<T>(klass);
        Table table = klass.getAnnotation(Table.class);
        em.setTableName(table == null || StringUtils.isEmpty((String)table.name()) ? StringUtils.lowerWord((CharSequence)klass.getSimpleName(), (char)'_') : table.name());
        if (table != null) {
            em.setTableComment(table.comment());
        }
        if (!TABLE_NAME_SET.add(em.getTableName())) {
            throw new NoEntityException(klass.getName(), "\u91cd\u590d\u8868\u540d:" + em.getTableName() + " \u2261 (^(OO)^) \u2261");
        }
        Field[] fields = FieldUtils.scanAllField(klass, ANNOTATIONS);
        if (fields.length <= 0) {
            throw new NoEntityException(klass.getName(), "\u6ca1\u6709\u53ef\u6620\u5c04\u7684\u5c5e\u6027 \u2261 (^(OO)^) \u2261");
        }
        boolean hasId = false;
        boolean hasPlayerId = false;
        ArrayList<FieldMapping> fieldInfo = new ArrayList<FieldMapping>(fields.length);
        for (Field field : fields) {
            FieldMapping fm = this.makeFieldMapping(klass, field, em.getMethodAccess());
            if (fm.isPrimaryId()) {
                if (hasId) {
                    throw new NoEntityException(klass.getName(), "\u4e00\u4e2a\u5b9e\u4f53\u4e2d\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a@Id \u2261 (^(OO)^) \u2261");
                }
                hasId = true;
                em.setPrimaryId(fm);
            }
            if (fm.isPlayerId()) {
                if (hasPlayerId) {
                    throw new NoEntityException(klass.getName(), "\u4e00\u4e2a\u5b9e\u4f53\u4e2d\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a@PlayerId \u2261 (^(OO)^) \u2261");
                }
                hasPlayerId = true;
                em.setPlayerId(fm);
            } else if (fm.isCreatedDate()) {
                em.setCreatedDate(fm);
            } else if (fm.isLastModifiedDate()) {
                em.setLastModifiedDate(fm);
            }
            fieldInfo.add(fm);
        }
        if (!hasId) {
            throw new NoEntityException(klass.getName(), "\u4e00\u4e2a\u5b9e\u4f53\u4e2d\u81f3\u5c11\u6709\u4e00\u4e2a@Id \u2261 (^(OO)^) \u2261");
        }
        em.setFieldInfo(fieldInfo);
        return em;
    }

    private FieldMapping makeFieldMapping(Class<?> klass, Field field, MethodAccess methodAccess) {
        FieldMapping fm = new FieldMapping(field, methodAccess);
        if (fm.getColumn() == null || StringUtils.isEmpty((String)fm.getColumn().name())) {
            fm.setColumnName(StringUtils.lowerWord((CharSequence)field.getName(), (char)'_'));
        } else {
            fm.setColumnName(fm.getColumn().name());
        }
        if (DataModular.CheckUnderScoreCase && !fm.getColumnName().equals(fm.getColumnName().toLowerCase())) {
            LogHelper.logger.warn("\u6570\u636e\u5e93\u5b57\u6bb5\u5e94\u8be5\u4f7f\u7528\u4e0b\u5212\u7ebf\u547d\u540d\u65b9\u5f0f,\u8bf7\u68c0\u67e5{}\u7c7b\u4e2d\u7684{}\u5c5e\u6027({})", new Object[]{klass.getName(), field.getName(), fm.getColumnName()});
        }
        this.guessEntityFieldColumnType(fm);
        return fm;
    }

    public void guessEntityFieldColumnType(FieldMapping fm) {
        Type type = fm.getField().getGenericType();
        if (type == Date.class) {
            fm.setType(FieldType.AsDate);
        } else if (type == LocalDateTime.class) {
            fm.setType(FieldType.AsLocalDateTime);
        } else if (fm.isJson()) {
            fm.setType(FieldType.AsJson);
            fm.setWidth(fm.getColumn() == null ? 1024 : fm.getColumn().length());
        } else if (fm.isInt()) {
            fm.setWidth(8);
            fm.setType(FieldType.AsInteger);
        } else if (fm.isString()) {
            fm.setType(FieldType.AsString);
            fm.setWidth(fm.getColumn() == null ? 255 : fm.getColumn().length());
        } else if (fm.isLong()) {
            fm.setWidth(16);
            fm.setType(FieldType.AsLong);
        } else if (Instant.class == type) {
            fm.setType(FieldType.AsInstant);
        } else if (fm.isBoolean()) {
            fm.setType(FieldType.AsBoolean);
        } else if (fm.isFloat()) {
            fm.setType(FieldType.AsFloat);
        } else if (fm.isDouble()) {
            fm.setType(FieldType.AsDouble);
        } else if (type == AtomicInteger.class) {
            fm.setWidth(8);
            fm.setType(FieldType.AsAtomicInteger);
        } else if (type == AtomicLong.class) {
            fm.setWidth(16);
            fm.setType(FieldType.AsAtomicLong);
        } else if (type == LongAdder.class) {
            fm.setWidth(16);
            fm.setType(FieldType.AsLongAdder);
        } else if (fm.isBlob()) {
            fm.setType(FieldType.AsBlob);
        } else {
            fm.setType(FieldType.AsJson);
            fm.setWidth(fm.getColumn() == null ? 1024 : fm.getColumn().length());
        }
    }

    static {
        ANNOTATIONS.add(Column.class);
        ANNOTATIONS.add(Id.class);
        ANNOTATIONS.add(PlayerId.class);
    }
}

