/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.init;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Component;
import xyz.noark.core.annotation.Value;
import xyz.noark.log.LogHelper;
import xyz.noark.network.handler.WebsocketServerHandler;
import xyz.noark.network.init.AbstractInitializeHandler;

@Component(name={"_______websocket_______"})
public class WebsocketInitializeHandler
extends AbstractInitializeHandler {
    public static final String WEBSOCKET_NAME = "_______websocket_______";
    @Value(value="network.websocket.path")
    protected String websocketPath = "/game";
    @Value(value="network.websocket.max.content.length")
    private int maxContentLength = 65535;
    @Autowired
    private WebsocketServerHandler websocketServerHandler;

    @Override
    public void handle(ChannelHandlerContext ctx) {
        LogHelper.logger.debug("WebSocket\u94fe\u63a5...");
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketFrameAggregator(this.maxContentLength)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.websocketPath)});
        pipeline.addLast(new ChannelHandler[]{this.websocketServerHandler});
    }
}

