/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http.intercept;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

class IpAllowListConfig {
    private static Pattern pattern = Pattern.compile("(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})");
    private final Set<String> ipList;

    IpAllowListConfig(String allowIp) {
        this.ipList = this.getAvailIpList(allowIp);
    }

    public Set<String> getAvailIpList(String allowIp) {
        HashSet<String> ipList = new HashSet<String>();
        for (String allow : allowIp.replaceAll("\\s", "").split(";")) {
            if (allow.indexOf("*") > -1) {
                String[] ips = allow.split("\\.");
                String[] from = new String[]{"0", "0", "0", "0"};
                String[] end = new String[]{"255", "255", "255", "255"};
                List<Object> tem = new ArrayList();
                for (int i = 0; i < ips.length; ++i) {
                    if (ips[i].indexOf("*") > -1) {
                        tem = IpAllowListConfig.complete(ips[i]);
                        from[i] = null;
                        end[i] = null;
                        continue;
                    }
                    from[i] = ips[i];
                    end[i] = ips[i];
                }
                StringBuffer fromIP = new StringBuffer();
                StringBuffer endIP = new StringBuffer();
                for (int i = 0; i < 4; ++i) {
                    if (from[i] != null) {
                        fromIP.append(from[i]).append(".");
                        endIP.append(end[i]).append(".");
                        continue;
                    }
                    fromIP.append("[*].");
                    endIP.append("[*].");
                }
                fromIP.deleteCharAt(fromIP.length() - 1);
                endIP.deleteCharAt(endIP.length() - 1);
                for (String string : tem) {
                    String ip = fromIP.toString().replace("[*]", string.split(";")[0]) + "-" + endIP.toString().replace("[*]", string.split(";")[1]);
                    if (!IpAllowListConfig.validate(ip)) continue;
                    ipList.add(ip);
                }
                continue;
            }
            if (!IpAllowListConfig.validate(allow)) continue;
            ipList.add(allow);
        }
        return ipList;
    }

    private static String complete(String arg, int length) {
        String from = "";
        String end = "";
        if (length == 1) {
            from = arg.replace("*", "0");
            end = arg.replace("*", "9");
        } else {
            from = arg.replace("*", "00");
            end = arg.replace("*", "99");
        }
        if (Integer.valueOf(from) > 255) {
            return null;
        }
        if (Integer.valueOf(end) > 255) {
            end = "255";
        }
        return from + ";" + end;
    }

    private static boolean validate(String ip) {
        for (String s : ip.split("-")) {
            if (pattern.matcher(s).matches()) continue;
            return false;
        }
        return true;
    }

    private static List<String> complete(String arg) {
        ArrayList<String> com = new ArrayList<String>();
        if (arg.length() == 1) {
            com.add("0;255");
        } else if (arg.length() == 2) {
            String s2;
            String s1 = IpAllowListConfig.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
            if ((s2 = IpAllowListConfig.complete(arg, 2)) != null) {
                com.add(s2);
            }
        } else {
            String s1 = IpAllowListConfig.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
        }
        return com;
    }

    public boolean access(String ip) {
        if (this.ipList.isEmpty() || this.ipList.contains(ip)) {
            return true;
        }
        for (String allow : this.ipList) {
            if (allow.indexOf("-") <= -1) continue;
            String[] from = allow.split("-")[0].split("\\.");
            String[] end = allow.split("-")[1].split("\\.");
            String[] tag = ip.split("\\.");
            boolean check = true;
            for (int i = 0; i < 4; ++i) {
                int s = Integer.valueOf(from[i]);
                int t = Integer.valueOf(tag[i]);
                int e = Integer.valueOf(end[i]);
                if (s <= t && t <= e) continue;
                check = false;
                break;
            }
            if (!check) continue;
            return true;
        }
        return false;
    }

    public boolean notAccess(String ip) {
        return !this.access(ip);
    }
}

