/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.MapUtils;
import xyz.noark.network.http.HttpServletRequest;
import xyz.noark.network.http.exception.UnrealizedMethodException;
import xyz.noark.network.util.ByteBufUtils;

class NoarkHttpServletRequest
implements HttpServletRequest {
    private final String uri;
    private final String method;
    private final String ip;
    private Map<String, String[]> parameterMap = Collections.emptyMap();

    NoarkHttpServletRequest(String uri, HttpMethod method, String ip) {
        this.uri = uri;
        this.method = method.name();
        this.ip = ip;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getParameter(String name) {
        String[] array = this.getParameterValues(name);
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public String getRemoteAddr() {
        return this.ip;
    }

    public String toString() {
        return "HttpServletRequest [uri=" + this.uri + ", parameters=" + JSON.toJSONString(this.parameterMap) + "]";
    }

    public void parse(FullHttpRequest fhr, QueryStringDecoder decoder) throws IOException {
        HttpMethod method = fhr.method();
        HashMap parameterMap = MapUtils.newHashMap((int)16);
        if (HttpMethod.GET == method) {
            this.parseGetRequestParameter(decoder, parameterMap);
        } else if (HttpMethod.POST == method) {
            this.parseGetRequestParameter(decoder, parameterMap);
            this.parsePostContent(fhr, parameterMap);
        } else {
            throw new UnrealizedMethodException(method.name(), decoder.path());
        }
        HashMap result = MapUtils.newHashMap((int)parameterMap.size());
        for (Map.Entry e : parameterMap.entrySet()) {
            result.put(e.getKey(), ((List)e.getValue()).toArray(new String[0]));
        }
        this.parameterMap = result;
    }

    private void parsePostContent(FullHttpRequest fhr, Map<String, List<String>> parameterMap) throws IOException {
        String contentType;
        switch (contentType = fhr.headers().get("Content-Type")) {
            case "application/json": {
                this.parseJsonContent(fhr, parameterMap);
                break;
            }
            default: {
                this.parsePostFromContent(fhr, parameterMap);
            }
        }
    }

    private void parsePostFromContent(FullHttpRequest fhr, Map<String, List<String>> parameterMap) throws IOException {
        List parameterList = new HttpPostRequestDecoder((HttpRequest)fhr).getBodyHttpDatas();
        for (InterfaceHttpData parameter : parameterList) {
            Attribute attr = (Attribute)parameter;
            parameterMap.computeIfAbsent(attr.getName(), key -> new ArrayList(1)).add(attr.getValue());
        }
    }

    private void parseJsonContent(FullHttpRequest fhr, Map<String, List<String>> parameterMap) {
        byte[] bs = ByteBufUtils.readBytes(fhr.content());
        JSONObject jsonObject = JSON.parseObject((String)new String(bs, CharsetUtils.CHARSET_UTF_8));
        for (Map.Entry e : jsonObject.entrySet()) {
            parameterMap.computeIfAbsent((String)e.getKey(), (Function<String, List<String>>)((Function<String, List>)key -> new ArrayList(1))).add(e.getValue().toString());
        }
    }

    private void parseGetRequestParameter(QueryStringDecoder decoder, Map<String, List<String>> parameterMap) {
        for (Map.Entry e : decoder.parameters().entrySet()) {
            parameterMap.computeIfAbsent((String)e.getKey(), (Function<String, List<String>>)((Function<String, List>)key -> new ArrayList(((List)e.getValue()).size()))).addAll((Collection)e.getValue());
        }
    }
}

