/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import java.util.List;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.ioc.wrap.method.HttpMethodWrapper;
import xyz.noark.core.network.HandlerMethod;
import xyz.noark.core.util.CollectionUtils;
import xyz.noark.network.http.HandlerInterceptor;
import xyz.noark.network.http.HttpServletRequest;
import xyz.noark.network.http.HttpServletResponse;

@Service
public class HandleInterceptChain {
    @Autowired
    private List<HandlerInterceptor> handlerInterceptorList;

    public boolean triggerPreHandle(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler) throws Exception {
        if (CollectionUtils.isEmpty(this.handlerInterceptorList)) {
            return false;
        }
        int len = this.handlerInterceptorList.size();
        for (int i = 0; i < len; ++i) {
            if (this.handlerInterceptorList.get(i).preHandle(request, response, (HandlerMethod)handler)) continue;
            return true;
        }
        return false;
    }

    public void triggerPostHandle(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler, Object result) throws Exception {
        if (CollectionUtils.isEmpty(this.handlerInterceptorList)) {
            return;
        }
        for (int i = this.handlerInterceptorList.size() - 1; i >= 0; --i) {
            this.handlerInterceptorList.get(i).postHandle(request, response, (HandlerMethod)handler);
        }
    }

    public void triggerAfterCompletion(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler) throws Exception {
        if (CollectionUtils.isEmpty(this.handlerInterceptorList)) {
            return;
        }
        for (int i = this.handlerInterceptorList.size() - 1; i >= 0; --i) {
            this.handlerInterceptorList.get(i).afterCompletion(request, response, (HandlerMethod)handler);
        }
    }
}

