/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import javax.annotation.PostConstruct;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.Session;
import xyz.noark.log.LogHelper;
import xyz.noark.network.WebSocketSession;
import xyz.noark.network.codec.AbstractWebsocketPacketCodec;
import xyz.noark.network.handler.AbstractServerHandler;

@Service
@ChannelHandler.Sharable
public class WebsocketServerHandler
extends AbstractServerHandler<WebSocketFrame> {
    private AbstractWebsocketPacketCodec codec;

    @PostConstruct
    public void init() {
        this.codec = (AbstractWebsocketPacketCodec)PacketCodecHolder.getPacketCodec();
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame wsf) throws Exception {
        this.dispatchPacket(ctx, this.codec.decodePacket(wsf.content().retain()));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            LogHelper.logger.info("WebSocket\u94fe\u63a5\u6210\u529f....");
            this.channelActive(ctx.channel());
        }
    }

    @Override
    protected Session createSession(Channel channel) {
        return new WebSocketSession(channel, false, this.secretKey);
    }
}

