/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.io.Serializable;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.network.NetworkListener;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.Session;
import xyz.noark.core.network.SessionManager;
import xyz.noark.core.thread.ThreadDispatcher;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.network.IncodeSession;
import xyz.noark.network.filter.PacketCheckFilter;

public abstract class AbstractServerHandler<T>
extends SimpleChannelInboundHandler<T> {
    @Autowired(required=false)
    protected NetworkListener networkListener;
    @Value(value="network.encrypt")
    protected boolean encrypt = false;
    @Value(value="network.secretkey")
    protected byte[] secretKey = StringUtils.utf8Bytes((CharSequence)"do{ManyLeavesFly();YangtzeRiverFlows();}while(1==1);");
    @Autowired
    private ThreadDispatcher threadDispatcher;
    @Autowired(required=false)
    private PacketCheckFilter packetCheckFilter;
    @Value(value="network.stat.receive.active")
    private boolean receiveActive = false;
    @Value(value="network.stat.receive.threshold")
    private int receiveThreshold = 65535;
    @Value(value="network.stat.receive.second")
    private int receiveSecond = 5;
    @Value(value="network.stat.receive.count")
    private int receiveCount = 3;

    public void channelActive(Channel channel) {
        Session session = SessionManager.createSession((Serializable)channel.id(), key -> this.createSession(channel));
        LogHelper.logger.debug("\u521b\u5efaSession={}", new Object[]{session.getId()});
        if (this.networkListener != null) {
            this.networkListener.channelActive(session);
        }
    }

    protected abstract Session createSession(Channel var1);

    protected void dispatchPacket(ChannelHandlerContext ctx, NetworkPacket packet) {
        try (ByteArray array = packet.getByteArray();){
            Session session = SessionManager.getSession((Serializable)ctx.channel().id());
            if (this.receiveActive) {
                this.statPacket(session, packet);
            }
            if (this.checkPacket(session, packet)) {
                this.threadDispatcher.dispatchPacket(session, packet);
            }
        }
    }

    private boolean checkPacket(Session session, NetworkPacket packet) {
        if (this.packetCheckFilter != null) {
            if (session instanceof IncodeSession && !this.packetCheckFilter.checkIncode((IncodeSession)session, packet)) {
                return false;
            }
            if (!this.packetCheckFilter.checkChecksum(session, packet)) {
                return false;
            }
        }
        if (session.getPacketEncrypt().isEncrypt()) {
            session.getPacketEncrypt().decode(packet.getByteArray(), packet.getIncode());
        }
        return true;
    }

    private void statPacket(Session session, NetworkPacket packet) {
        int warnCount;
        long second = System.currentTimeMillis() / 1000L;
        long packetLength = session.getStatis().record(second, packet.getLength());
        if (packetLength >= (long)this.receiveThreshold && (warnCount = session.getStatis().warning(second, this.receiveSecond)) >= this.receiveCount) {
            LogHelper.logger.warn("\u7f51\u7edc\u5c01\u5305\u7edf\u8ba1\u9884\u8b66\uff1a\u5728 {} \u79d2\u5185\u7d2f\u8ba1 {} \u6b21\u8d85\u51fa {} \u9884\u8b66\u503c", new Object[]{this.receiveSecond, warnCount, this.receiveThreshold});
            if (this.networkListener != null && this.networkListener.handlePacketWarning(session, this.receiveSecond, warnCount, this.receiveThreshold)) {
                return;
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!(cause instanceof IOException)) {
            LogHelper.logger.debug("Netty\u6355\u83b7\u5f02\u5e38\uff0ccause={}", new Object[]{cause});
        }
    }
}

