/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.codec.protobuf;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.exception.DataException;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.lang.ByteArrayOutputStream;
import xyz.noark.core.lang.ImmutableByteArray;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.NetworkProtocol;
import xyz.noark.core.util.MethodUtils;
import xyz.noark.core.util.UnsignedUtils;
import xyz.noark.network.codec.AbstractPacketCodec;
import xyz.noark.network.codec.ByteBufWrapper;
import xyz.noark.network.codec.DefaultNetworkPacket;
import xyz.noark.network.codec.protobuf.ProtobufLengthDecoder;
import xyz.noark.network.codec.protobuf.ProtobufLengthEncoder;

public class ProtobufCodec
extends AbstractPacketCodec {
    private static final ConcurrentHashMap<Class<?>, Method> CACHES = new ConcurrentHashMap(1024);

    public <T> T decodeProtocol(ByteArray bytes, Class<T> klass) {
        Method method = CACHES.computeIfAbsent(klass, key -> MethodUtils.getMethod((Class)key, (String)"parseFrom", (Class[])new Class[]{byte[].class}));
        return (T)MethodUtils.invoke(null, (Method)method, (Object[])new Object[]{bytes.array()});
    }

    public ByteArray encodePacket(NetworkProtocol networkProtocol) {
        int opcode = (Integer)networkProtocol.getOpcode();
        if (opcode > Short.MAX_VALUE) {
            throw new UnrealizedException("illegal opcode=" + opcode + ", max=65535");
        }
        MessageLite message = null;
        if (networkProtocol.getProtocol() instanceof MessageLite) {
            message = (MessageLite)networkProtocol.getProtocol();
        } else if (networkProtocol.getProtocol() instanceof MessageLite.Builder) {
            message = ((MessageLite.Builder)networkProtocol.getProtocol()).build();
        } else {
            throw new UnrealizedException("illegal data type\uff1a" + networkProtocol.getProtocol().getClass());
        }
        ImmutableByteArray byteArray = new ImmutableByteArray(message.getSerializedSize() + 2);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((ByteArray)byteArray);){
            byteArrayOutputStream.writeShortLE(opcode);
            try {
                message.writeTo((OutputStream)byteArrayOutputStream);
            }
            catch (IOException e) {
                throw new DataException("PB writeTo exception", (Throwable)e);
            }
            ImmutableByteArray immutableByteArray = byteArray;
            return immutableByteArray;
        }
    }

    @Override
    public MessageToByteEncoder<?> lengthEncoder() {
        return new ProtobufLengthEncoder();
    }

    @Override
    public ByteToMessageDecoder lengthDecoder() {
        return new ProtobufLengthDecoder(this);
    }

    @Override
    public NetworkPacket decodePacket(ByteBuf byteBuf) {
        DefaultNetworkPacket packet = new DefaultNetworkPacket();
        packet.setLength(byteBuf.readableBytes());
        packet.setIncode(UnsignedUtils.toUnsigned((short)byteBuf.readShortLE()));
        packet.setChecksum(UnsignedUtils.toUnsigned((short)byteBuf.readShortLE()));
        packet.setOpcode(Integer.valueOf(UnsignedUtils.toUnsigned((short)byteBuf.readShortLE())));
        packet.setBytes(new ByteBufWrapper(byteBuf));
        return packet;
    }
}

