/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import xyz.noark.network.InitializeHandlerManager;
import xyz.noark.network.util.ByteBufUtils;

public class InitializeDecoder
extends ByteToMessageDecoder {
    private static final int MAX_LENGTH = 23;
    private static final String WEBSOCKET_PREFIX = "GET /";
    private final InitializeHandlerManager initializeHandlerManager;

    public InitializeDecoder(InitializeHandlerManager initializeHandlerManager) {
        this.initializeHandlerManager = initializeHandlerManager;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int length = in.readableBytes();
        if (length > 23) {
            length = 23;
        }
        in.markReaderIndex();
        String protocol = ByteBufUtils.readString(in, length);
        if (protocol.startsWith(WEBSOCKET_PREFIX)) {
            in.resetReaderIndex();
            protocol = "_______websocket_______";
        }
        this.initializeHandlerManager.getHandler(protocol).handle(ctx);
        ctx.pipeline().remove(((Object)((Object)this)).getClass());
    }
}

