/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import xyz.noark.log.AbstractMessage;
import xyz.noark.log.Level;
import xyz.noark.log.MessageAnalyzer;
import xyz.noark.log.MessageAnalyzerManager;
import xyz.noark.log.MessageHelper;

class ParameterizedMessage
extends AbstractMessage {
    private static final MessageAnalyzerManager CACHE = new MessageAnalyzerManager();
    private final Object[] args;

    ParameterizedMessage(Level level, String messagePattern, Object[] args) {
        super(level, messagePattern);
        this.args = this.handleArgs(args);
    }

    private Object[] handleArgs(Object[] args) {
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            args[i] = MessageHelper.preprocessingEnteringLogThreadBefore(args[i]);
        }
        return args;
    }

    @Override
    protected void onBuildMessage(StringBuilder sb) {
        CACHE.get(this.msg, key -> new MessageAnalyzer((String)key)).build(sb, this.args);
    }
}

