/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import xyz.noark.log.ThreadSafe;

class MessageHelper {
    private static final SimpleDateFormat DEFAULT_PATTERN = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private MessageHelper() {
    }

    static Object preprocessingEnteringLogThreadBefore(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof Number || object instanceof Date || object instanceof Character) {
            return object;
        }
        if (object instanceof Throwable || object.getClass().isAnnotationPresent(ThreadSafe.class)) {
            return object;
        }
        if (object.getClass().isArray()) {
            if (object instanceof byte[]) {
                return Arrays.toString((byte[])object);
            }
            if (object instanceof short[]) {
                return Arrays.toString((short[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            if (object instanceof long[]) {
                return Arrays.toString((long[])object);
            }
            if (object instanceof float[]) {
                return Arrays.toString((float[])object);
            }
            if (object instanceof double[]) {
                return Arrays.toString((double[])object);
            }
            if (object instanceof String[]) {
                return Arrays.toString((String[])object);
            }
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    static void append(StringBuilder sb, Object object) {
        if (object == null) {
            sb.append(object);
        } else if (object instanceof Throwable) {
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                ((Throwable)object).printStackTrace(pw);
                sb.append("\n").append(sw.toString());
            }
            catch (Exception e) {
                sb.append(object);
            }
        } else if (object instanceof Date) {
            sb.append(DEFAULT_PATTERN.format(object));
        } else {
            sb.append(object);
        }
    }
}

