/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.util.ArrayList;
import xyz.noark.log.MessageHelper;

class MessageAnalyzer {
    private static final char DELIMIT_START = '{';
    private static final char DELIMIT_STOP = '}';
    private ArrayList<Placeholder> caches = new ArrayList();
    private int count = 0;

    MessageAnalyzer(String key) {
        this.init(key);
        this.caches.trimToSize();
    }

    private static boolean isDelimitPair(char curChar, String messagePattern, int curCharIndex) {
        return curChar == '{' && messagePattern.charAt(curCharIndex + 1) == '}';
    }

    int getCount() {
        return this.count;
    }

    private void init(String messagePattern) {
        int i;
        int beginIndex = 0;
        int index = 0;
        int len = messagePattern.length();
        for (i = 0; i < len - 1; ++i) {
            char curChar = messagePattern.charAt(i);
            if (!MessageAnalyzer.isDelimitPair(curChar, messagePattern, i)) continue;
            if (beginIndex != i) {
                this.caches.add(new StrPlaceholder(messagePattern.substring(beginIndex, i)));
            }
            ++this.count;
            this.caches.add(new ObjPlaceholder(index++));
            beginIndex = i + 2;
            ++i;
        }
        if (beginIndex <= i && i < len) {
            this.caches.add(new StrPlaceholder(messagePattern.substring(beginIndex, i + 1)));
        }
    }

    public void build(StringBuilder sb, Object[] args) {
        for (Placeholder object : this.caches) {
            object.build(sb, args);
        }
        if (args.length > this.count) {
            for (int i = this.count; i < args.length; ++i) {
                MessageHelper.append(sb, ",{");
                MessageHelper.append(sb, i);
                MessageHelper.append(sb, "}=");
                MessageHelper.append(sb, args[i]);
            }
        }
    }

    public String toString() {
        return "MessageAnalyzer [caches=" + this.caches + "]";
    }

    class ObjPlaceholder
    implements Placeholder {
        private int index;

        public ObjPlaceholder(int index) {
            this.index = index;
        }

        @Override
        public void build(StringBuilder sb, Object[] args) {
            if (args.length > this.index) {
                MessageHelper.append(sb, args[this.index]);
            } else {
                sb.append("{}");
            }
        }

        public String toString() {
            return "ObjPlaceholder [index=" + this.index + ", toString()=" + super.toString() + "]";
        }
    }

    class StrPlaceholder
    implements Placeholder {
        private String str;

        public StrPlaceholder(String str) {
            this.str = str;
        }

        @Override
        public void build(StringBuilder sb, Object[] args) {
            sb.append(this.str);
        }

        public String toString() {
            return "StrPlaceholder [str=" + this.str + "]";
        }
    }

    static interface Placeholder {
        public void build(StringBuilder var1, Object[] var2);
    }
}

