/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class LogPath {
    private final String path;
    private final boolean activate;
    private DateTimeFormatter formatter = null;
    private String prefix;
    private String suffix;

    LogPath() {
        this(null);
    }

    LogPath(String path) {
        this.path = path;
        boolean bl = this.activate = path != null && !"".equals(path);
        if (this.activate) {
            int start = path.indexOf("{");
            int end = path.lastIndexOf("}");
            if (start > 0 && end > start) {
                String dateFormat = path.substring(start + 1, end);
                this.formatter = DateTimeFormatter.ofPattern(dateFormat);
                this.prefix = path.substring(0, start);
                this.suffix = path.substring(end + 1);
            }
        }
    }

    public String getPath(LocalDateTime date) {
        if (this.formatter == null) {
            return this.path;
        }
        return new StringBuilder(this.path.length()).append(this.prefix).append(date.format(this.formatter)).append(this.suffix).toString();
    }

    public boolean isActivate() {
        return this.activate;
    }
}

