/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import xyz.noark.log.LogConfigurator;
import xyz.noark.log.LogOutputManager;
import xyz.noark.log.Message;

class LogOutputTask
implements Runnable {
    private final Message message;
    private final LogOutputManager outputManager;

    LogOutputTask(Message message, LogOutputManager outputManager) {
        this.message = message;
        this.outputManager = outputManager;
    }

    @Override
    public void run() {
        try {
            char[] text = this.message.build();
            if (LogConfigurator.CONSOLE) {
                this.outputManager.recordToConsole(this.message.getLevel(), text);
            }
            if (LogConfigurator.LOG_PATH.isActivate()) {
                this.outputManager.recordToFile(this.message.getDate(), text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

