/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import xyz.noark.log.Level;
import xyz.noark.log.LogConfigurator;
import xyz.noark.log.LogFileWriter;
import xyz.noark.log.LogOutputTask;
import xyz.noark.log.Message;

class LogOutputManager {
    private static final LogOutputManager INSTANCE = new LogOutputManager();
    private final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "async-log");
            t.setDaemon(true);
            return t;
        }
    });
    private LogFileWriter fileWriter = null;
    private int lastWriterHour = -1;

    private LogOutputManager() {
    }

    public static LogOutputManager getInstance() {
        return INSTANCE;
    }

    public void asyncLog(Message message) {
        this.scheduledExecutor.execute(new LogOutputTask(message, this));
    }

    public void shutdown() {
        this.scheduledExecutor.shutdown();
        try {
            this.scheduledExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.flushAndClose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void recordToConsole(Level level, char[] text) {
        switch (level) {
            case DEBUG: 
            case INFO: {
                System.out.print(text);
                break;
            }
            default: {
                System.err.print(text);
            }
        }
    }

    public void recordToFile(LocalDateTime logTime, char[] text) throws IOException {
        this.checkRollover(logTime);
        this.fileWriter.writer(text);
    }

    private void checkRollover(LocalDateTime logTime) throws IOException {
        if (logTime.getHour() != this.lastWriterHour) {
            this.rollover(logTime);
        }
    }

    private void rollover(LocalDateTime logTime) throws IOException {
        this.flushAndClose();
        File file = this.createNewFile(LogConfigurator.LOG_PATH.getPath(logTime));
        this.fileWriter = new LogFileWriter(file, this.scheduledExecutor);
        this.lastWriterHour = logTime.getHour();
    }

    private void flushAndClose() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
    }

    private File createNewFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        file.createNewFile();
        return file;
    }
}

