/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.util.Map;
import xyz.noark.log.Level;
import xyz.noark.log.LogConfigurator;
import xyz.noark.log.LogHelper;
import xyz.noark.log.LogOutputManager;
import xyz.noark.log.LogPath;
import xyz.noark.log.Logger;

public class LogManager {
    private static final String LOG_LEVEL = "log.level";
    private static final String LOG_CONSOLE = "log.console";
    private static final String LOG_PATH = "log.path";

    public static void init(Map<String, String> config) {
        LogConfigurator.DEFAULT_LEVEL = Level.valueOf(config.getOrDefault(LOG_LEVEL, "debug").toUpperCase());
        LogConfigurator.CONSOLE = Boolean.valueOf(config.getOrDefault(LOG_CONSOLE, "true"));
        LogConfigurator.LOG_PATH = new LogPath(config.get(LOG_PATH));
    }

    public static void shutdown() {
        LogOutputManager.getInstance().shutdown();
    }

    public static Logger getDefaultLogger() {
        return LogHelper.logger;
    }
}

