/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import xyz.noark.log.LogOutputFlushTask;

class LogFileWriter {
    private final ScheduledFuture<?> future;
    private final FileWriter fileWriter;
    private final BufferedWriter bufferedWriter;

    LogFileWriter(File file, ScheduledExecutorService scheduledExecutor) throws IOException {
        this.fileWriter = new FileWriter(file, true);
        this.bufferedWriter = new BufferedWriter(this.fileWriter);
        this.future = scheduledExecutor.scheduleWithFixedDelay(new LogOutputFlushTask(this), 1L, 1L, TimeUnit.SECONDS);
    }

    void writer(char[] text) throws IOException {
        this.bufferedWriter.write(text);
    }

    public void flush() throws IOException {
        this.bufferedWriter.flush();
    }

    public void close() throws IOException {
        this.future.cancel(true);
        this.bufferedWriter.close();
        this.fileWriter.close();
    }
}

