/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import xyz.noark.log.Level;
import xyz.noark.log.LogConfigurator;
import xyz.noark.log.Message;

abstract class AbstractMessage
implements Message {
    private static final StringBuilder DEFAULT_LOG_BUILDER = new StringBuilder(512);
    private static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    protected final String msg;
    protected final LocalDateTime date;
    private final Level level;
    private final String threadName;
    private String fileName;
    private int lineNumber;

    AbstractMessage(Level level, String msg) {
        this.level = level;
        this.msg = msg;
        this.date = LocalDateTime.now();
        Thread thread = Thread.currentThread();
        this.threadName = thread.getName();
        if (LogConfigurator.DEFAULT_LEVEL == Level.DEBUG) {
            StackTraceElement[] elements = thread.getStackTrace();
            for (int i = 7; i < elements.length; ++i) {
                StackTraceElement stackTraceElement = elements[i];
                this.fileName = stackTraceElement.getFileName();
                this.lineNumber = stackTraceElement.getLineNumber();
                if (this.fileName != null && !this.fileName.endsWith("Logger.java")) break;
            }
        }
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public LocalDateTime getDate() {
        return this.date;
    }

    @Override
    public char[] build() {
        DEFAULT_LOG_BUILDER.setLength(0);
        DEFAULT_LOG_BUILDER.append(DEFAULT_DATE_FORMATTER.format(this.date));
        DEFAULT_LOG_BUILDER.append(' ').append((Object)this.level).append(" [").append(this.threadName).append("]");
        if (LogConfigurator.DEFAULT_LEVEL == Level.DEBUG) {
            DEFAULT_LOG_BUILDER.append(" [").append(this.fileName).append(":").append(this.lineNumber).append("]");
        }
        DEFAULT_LOG_BUILDER.append(" - ");
        this.onBuildMessage(DEFAULT_LOG_BUILDER);
        DEFAULT_LOG_BUILDER.append("\n");
        char[] result = new char[DEFAULT_LOG_BUILDER.length()];
        DEFAULT_LOG_BUILDER.getChars(0, result.length, result, 0);
        return result;
    }

    protected abstract void onBuildMessage(StringBuilder var1);
}

