/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.log;

import xyz.noark.log.Level;
import xyz.noark.log.LogConfigurator;
import xyz.noark.log.LogOutputManager;
import xyz.noark.log.MessageFactory;

abstract class AbstractLogger {
    private static final LogOutputManager OUTPUT_MANAGER = LogOutputManager.getInstance();

    AbstractLogger() {
    }

    protected void logIfEnabled(Level level, String msg, Object ... args) {
        if (this.isEnabled(level)) {
            this.logMessage(level, msg, args);
        }
    }

    private boolean isEnabled(Level level) {
        return LogConfigurator.DEFAULT_LEVEL.getValue() <= level.getValue();
    }

    private void logMessage(Level level, String msg, Object ... args) {
        OUTPUT_MANAGER.asyncLog(MessageFactory.create(level, msg, args));
    }
}

