/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

public class ProtobufUtils {
    private static final int MAX_VALUE = -1;
    private static final int ONE_BYTE_LENGTH = 7;
    private static final int TWO_BYTE_LENGTH = 14;
    private static final int THREE_BYTE_LENGTH = 21;
    private static final int FOUR_BYTE_LENGTH = 28;

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static byte[] encodeInt32(int value) {
        byte[] result = new byte[ProtobufUtils.computeRawVarint32Size(value)];
        int len = result.length;
        for (int i = 0; i < len; ++i) {
            if ((value & 0xFFFFFF80) == 0) {
                result[i] = (byte)value;
                continue;
            }
            result[i] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
        return result;
    }
}

