/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.util.Stack;

public class HtmlUtils {
    public static String toUnityHtml(String html) {
        Stack<HtmlTag> stack = new Stack<HtmlTag>();
        StringBuilder sb = new StringBuilder(html.length());
        int len = html.length();
        for (int i = 0; i < len; ++i) {
            char cur = html.charAt(i);
            if (cur == '<' && len > i + 1) {
                HtmlTag tag = HtmlUtils.readTag(html, i);
                i = tag.getLength();
                if (tag.isEnd()) {
                    if (!stack.isEmpty() && ((HtmlTag)stack.peek()).getName().equals(tag.getName())) {
                        tag = (HtmlTag)stack.pop();
                    }
                    tag.html(sb, true);
                    continue;
                }
                stack.push(tag);
                tag.html(sb, false);
                continue;
            }
            sb.append(cur);
        }
        return sb.toString();
    }

    private static HtmlTag readTag(String html, int index) {
        HtmlTag tag = new HtmlTag();
        StringBuilder sb = new StringBuilder(16);
        boolean color = false;
        boolean size = false;
        int len = html.length();
        for (int i = index + 1; i < len; ++i) {
            char cur = html.charAt(i);
            if (cur == '/') {
                tag.setEnd(true);
                continue;
            }
            if (cur == ' ') {
                tag.setName(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (cur == '>') {
                if (tag.getName() == null) {
                    tag.setName(sb.toString());
                }
                tag.setLength(i);
                break;
            }
            if (cur == '\"') {
                if (color) {
                    tag.setColor(sb.toString());
                    color = false;
                } else if (size) {
                    tag.setSize(sb.toString().replace("px", ""));
                    size = false;
                }
                sb.setLength(0);
                continue;
            }
            if (cur == ':') {
                if ("color".equals(sb.toString())) {
                    color = true;
                } else if ("font-size".equals(sb.toString())) {
                    size = true;
                }
                sb.setLength(0);
                continue;
            }
            if (cur == ';') {
                if (color) {
                    tag.setColor(sb.toString());
                    color = false;
                } else if (size) {
                    tag.setSize(sb.toString().replace("px", ""));
                    size = false;
                }
                sb.setLength(0);
                continue;
            }
            sb.append(cur);
        }
        return tag;
    }

    static class HtmlTag {
        private String name;
        private boolean end;
        private int length;
        private String color;
        private String size;

        HtmlTag() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEnd() {
            return this.end;
        }

        public void setEnd(boolean end) {
            this.end = end;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public void html(StringBuilder sb, boolean isEnd) {
            switch (this.name) {
                case "b": 
                case "strong": {
                    sb.append(isEnd ? "</b>" : "<b>");
                    break;
                }
                case "i": 
                case "em": {
                    sb.append(isEnd ? "</i>" : "<i>");
                    break;
                }
                case "span": {
                    if (this.size != null) {
                        sb.append(isEnd ? "</size>" : "<size=" + this.size + ">");
                    }
                    if (this.color == null) break;
                    sb.append(isEnd ? "</color>" : "<color=" + this.color + ">");
                    break;
                }
                case "br": {
                    sb.append(isEnd ? "<br>" : "");
                    break;
                }
            }
        }

        public String toString() {
            return "HtmlTag [name=" + this.name + ", end=" + this.end + ", length=" + this.length + ", color=" + this.color + ", size=" + this.size + "]";
        }
    }
}

