/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import xyz.noark.core.util.MathUtils;
import xyz.noark.core.util.StringUtils;

public class DateUtils {
    public static final int MILLISECOND_PER_SECOND = 1000;
    public static final int SECOND_PER_MINUTE = 60;
    public static final int MINUTE_PER_HOUR = 60;
    public static final int HOUR_PER_DAY = 24;

    public static boolean isSameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameWeek(LocalDate date1, LocalDate date2) {
        return DateUtils.isSameWeek(date1, date2, WeekFields.ISO);
    }

    public static boolean isSameWeek(LocalDate date1, LocalDate date2, WeekFields weekFields) {
        TemporalField temporalField = weekFields.weekOfWeekBasedYear();
        return date1.get(temporalField) == date2.get(temporalField);
    }

    public static boolean isSameWeek(Date date1, Date date2) {
        return DateUtils.isSameWeek(DateUtils.toLocalDate(date1), DateUtils.toLocalDate(date2));
    }

    public static boolean isSameWeek(Date date1, Date date2, WeekFields weekFields) {
        return DateUtils.isSameWeek(DateUtils.toLocalDate(date1), DateUtils.toLocalDate(date2), weekFields);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameMonth(cal1, cal2);
    }

    public static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateUtils.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (amount == 0) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static long toSeconds(Date date) {
        return DateUtils.toSeconds(date.getTime());
    }

    public static long toSeconds(long milliseconds) {
        return milliseconds / 1000L;
    }

    public static long toSecondsByStartOfDay(LocalDate localDate) {
        return localDate.atStartOfDay(ZoneOffset.systemDefault()).toEpochSecond();
    }

    public static long toDays(Date date) {
        return DateUtils.toDays(date.getTime() + (long)TimeZone.getDefault().getRawOffset());
    }

    public static long toDays(long milliseconds) {
        return milliseconds / 86400000L;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate toLocalDate(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalTime();
    }

    public static Date from(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long diffSeconds(Date date1, Date date2) {
        return DateUtils.toSeconds(date1) - DateUtils.toSeconds(date2);
    }

    public static long diffDays(Date date1, Date date2) {
        int offset = TimeZone.getDefault().getRawOffset();
        return DateUtils.toDays(date1.getTime() + (long)offset) - DateUtils.toDays(date2.getTime() + (long)offset);
    }

    public static String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "00:00:00";
        }
        int second = (int)(seconds % 60L);
        int minute = (int)((seconds /= 60L) % 60L);
        long hour = seconds /= 60L;
        StringBuilder sb = new StringBuilder(StringUtils.asciiSizeInBytes(hour) + 6);
        sb.append(hour < 10L ? "0" : "").append(hour).append(":");
        sb.append(minute < 10 ? "0" : "").append(minute).append(":");
        sb.append(second < 10 ? "0" : "").append(second);
        return sb.toString();
    }

    public static float formatNanoTime(long nanoTime) {
        return MathUtils.formatScale((float)nanoTime / 1000000.0f, 2);
    }

    public static DayOfWeek getDayOfWeek(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).getDayOfWeek();
    }

    public static Date getStartOfDay(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        return now.getTime();
    }
}

