/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.network;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.network.NetworkProtocol;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.Session;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;

public class SessionManager {
    private static final ConcurrentMap<Serializable, Session> SESSIONS = new ConcurrentHashMap<Serializable, Session>(2048);
    private static final ConcurrentMap<Serializable, Session> PLAYER_ID_2_SESSION = new ConcurrentHashMap<Serializable, Session>(2048);
    private static final ConcurrentMap<Serializable, Session> UID_2_SESSION = new ConcurrentHashMap<Serializable, Session>(2048);

    public static Session createSession(Serializable id, Function<Serializable, Session> mappingFunction) {
        return SESSIONS.computeIfAbsent(id, mappingFunction);
    }

    public static void send(Serializable opcode, Object protocol, Serializable ... playerIds) {
        ByteArray packet = PacketCodecHolder.getPacketCodec().encodePacket(new NetworkProtocol(opcode, protocol));
        if (playerIds.length == 0) {
            PLAYER_ID_2_SESSION.forEach((k, v) -> v.send(packet));
        } else {
            for (Serializable playerId : playerIds) {
                Session session = (Session)PLAYER_ID_2_SESSION.get(playerId);
                if (session == null) {
                    LogHelper.logger.debug("\u672a\u627e\u5230Session\uff0c\u65e0\u6cd5\u53d1\u9001, playerId={}", new Object[]{playerId});
                    continue;
                }
                session.send(packet);
            }
        }
    }

    public static void removeSession(Session session) {
        SESSIONS.remove(session.getId());
        if (session.getPlayerId() != null) {
            PLAYER_ID_2_SESSION.remove(session.getPlayerId());
        }
        if (StringUtils.isNotEmpty(session.getUid())) {
            UID_2_SESSION.remove(session.getUid());
        }
    }

    public static Optional<Session> setUidAndSession(String uid, Session session) {
        return Optional.ofNullable(UID_2_SESSION.put((Serializable)((Object)uid), session));
    }

    public static void bindPlayerIdAndSession(Serializable playerId, Session session) {
        PLAYER_ID_2_SESSION.put(playerId, session);
    }

    public static Session getSession(Serializable id) {
        return (Session)SESSIONS.get(id);
    }

    public static Session getSessionByPlayerId(Serializable playerId) {
        return (Session)PLAYER_ID_2_SESSION.get(playerId);
    }

    public static Optional<Session> loadSessionByPlayerId(Serializable playerId) {
        return Optional.ofNullable(SessionManager.getSessionByPlayerId(playerId));
    }

    public static Session getSessionByUid(Serializable uid) {
        return (Session)UID_2_SESSION.get(uid);
    }

    public static Optional<Session> loadSessionByUid(Serializable uid) {
        return Optional.ofNullable(SessionManager.getSessionByUid(uid));
    }

    public static Collection<Session> getOnlineSessionList() {
        return PLAYER_ID_2_SESSION.values();
    }

    public static Set<Serializable> getOnlinePlayerIdList() {
        return PLAYER_ID_2_SESSION.keySet();
    }

    public static boolean isOnline(Serializable playerId) {
        return PLAYER_ID_2_SESSION.containsKey(playerId);
    }

    public static int statOnlinePlayerNum() {
        return PLAYER_ID_2_SESSION.size();
    }

    public static int statOnlineUidNum() {
        return UID_2_SESSION.size();
    }

    public static int statSessionNum() {
        return SESSIONS.size();
    }
}

