/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private long startTimeNano;
    private long totalTimeNano;
    private String currentTaskName;
    private final boolean taskListEnabled;
    private final List<TaskInfo> taskList;

    public StopWatch() {
        this(false);
    }

    public StopWatch(boolean taskListEnabled) {
        this.taskListEnabled = taskListEnabled;
        this.taskList = taskListEnabled ? new LinkedList() : null;
    }

    public void start() {
        this.start("");
    }

    public void start(String taskName) {
        this.currentTaskName = taskName;
        this.startTimeNano = System.nanoTime();
    }

    public void stop() {
        long execTime = System.nanoTime() - this.startTimeNano;
        this.totalTimeNano += execTime;
        if (this.taskListEnabled) {
            this.taskList.add(new TaskInfo(this.currentTaskName, execTime));
        }
        this.currentTaskName = null;
    }

    public long getTotalTimeNano() {
        return this.totalTimeNano;
    }

    public float getTotalTimeMillis() {
        return (float)this.totalTimeNano / 1000000.0f;
    }

    public String shortSummary() {
        return "StopWatch: running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        if (!this.taskListEnabled) {
            sb.append("No task info kept");
        } else {
            sb.append("-----------------------------------------\n");
            sb.append("ms     %     Task name\n");
            sb.append("-----------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.taskList) {
                sb.append(nf.format(task.getTimeMillis())).append("  ");
                sb.append(pf.format(1.0 * (double)task.getTimeNano() / (double)this.getTotalTimeNano())).append("  ");
                sb.append(task.getTaskName()).append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        if (this.taskListEnabled) {
            for (TaskInfo task : this.taskList) {
                sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTimeMillis());
                long percent = Math.round(100.0 * (double)task.getTimeNano() / (double)this.getTotalTimeNano());
                sb.append(" = ").append(percent).append("%");
            }
        } else {
            sb.append("; no task info kept");
        }
        return sb.toString();
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long timeNano;

        TaskInfo(String taskName, long timeNano) {
            this.taskName = taskName;
            this.timeNano = timeNano;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeNano() {
            return this.timeNano;
        }

        public long getTimeMillis() {
            return this.timeNano / 1000000L;
        }
    }
}

