/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import xyz.noark.core.lang.Mutable;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = -5425153499522349930L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong(Number value) {
        this(value.longValue());
    }

    public MutableLong(String value) {
        this.value = Long.parseLong(value);
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(Number value) {
        this.value = value.longValue();
    }

    @Override
    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public int compareTo(MutableLong anotherInteger) {
        return Long.compare(this.value, anotherInteger.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableLong) {
            return this.value == ((MutableLong)obj).longValue();
        }
        return false;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public final long getAndIncrement() {
        long oldValue = this.value++;
        return oldValue;
    }

    public final long getAndDecrement() {
        long oldValue = this.value--;
        return oldValue;
    }

    public final long getAndAdd(int delta) {
        long oldValue = this.value;
        this.value += (long)delta;
        return oldValue;
    }

    public final long incrementAndGet() {
        return ++this.value;
    }

    public final long decrementAndGet() {
        return --this.value;
    }

    public final long addAndGet(int delta) {
        return this.value += (long)delta;
    }
}

