/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import xyz.noark.core.lang.Mutable;

public class MutableDouble
extends Number
implements Comparable<MutableDouble>,
Mutable<Number> {
    private static final long serialVersionUID = -8771778938501730509L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(Number value) {
        this(value.doubleValue());
    }

    public MutableDouble(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(Number value) {
        this.value = value.doubleValue();
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public int compareTo(MutableDouble other) {
        return Double.compare(this.value, other.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableDouble) {
            return this.value == ((MutableDouble)obj).doubleValue();
        }
        return false;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public final double getAndIncrement() {
        double oldValue = this.value;
        this.value += 1.0;
        return oldValue;
    }

    public final double getAndDecrement() {
        double oldValue = this.value;
        this.value -= 1.0;
        return oldValue;
    }

    public final double getAndAdd(double delta) {
        double oldValue = this.value;
        this.value += delta;
        return oldValue;
    }

    public final double incrementAndGet() {
        return this.value += 1.0;
    }

    public final double decrementAndGet() {
        return this.value -= 1.0;
    }

    public final double addAndGet(double delta) {
        return this.value += delta;
    }
}

