/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import xyz.noark.core.lang.IntList;

public class IntArrayList
implements IntList,
RandomAccess {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int[] EMPTY_ELEMENT_DATA = new int[0];
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private int[] elementData;
    private int size = 0;

    public IntArrayList() {
        this.elementData = EMPTY_ELEMENT_DATA;
    }

    public IntArrayList(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elementData = new int[initialCapacity];
        } else if (initialCapacity == 0) {
            this.elementData = EMPTY_ELEMENT_DATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public IntArrayList(int[] array) {
        this.elementData = array;
        this.size = this.elementData.length;
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public void trimToSize() {
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENT_DATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    @Override
    public int random() {
        return this.elementData[ThreadLocalRandom.current().nextInt(0, this.size)];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(int o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(int o) {
        for (int i = 0; i < this.size; ++i) {
            if (o != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int x) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (x != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public int get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public boolean add(int e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public boolean remove(int o) {
        for (int index = 0; index < this.size; ++index) {
            if (o != this.elementData[index]) continue;
            this.fastRemove(index);
            return true;
        }
        return false;
    }

    private void fastRemove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public boolean addAll(int[] a) {
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private void ensureCapacityInternal(int minCapacity) {
        if (this.elementData == EMPTY_ELEMENT_DATA) {
            minCapacity = Math.max(10, minCapacity);
        }
        this.ensureExplicitCapacity(minCapacity);
    }

    private void ensureExplicitCapacity(int minCapacity) {
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = IntArrayList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    public void forEach(Consumer<? super Integer> action) {
        Objects.requireNonNull(action);
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept((Integer)this.elementData[i]);
        }
    }

    @Override
    public List<Integer> toList() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.add(this.elementData[i]);
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + Integer.hashCode(this.elementData[i]);
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntList)) {
            return false;
        }
        IntList target = (IntList)o;
        if (this.size() != target.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == target.get(i)) continue;
            return false;
        }
        return true;
    }
}

