/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.method;

import java.io.Serializable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import xyz.noark.core.annotation.PlayerId;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.ioc.definition.method.PacketMethodDefinition;
import xyz.noark.core.ioc.wrap.ParamWrapper;
import xyz.noark.core.ioc.wrap.method.AbstractControllerMethodWrapper;
import xyz.noark.core.ioc.wrap.param.ByteArrayParamWrapper;
import xyz.noark.core.ioc.wrap.param.NetworkPacketParamWrapper;
import xyz.noark.core.ioc.wrap.param.PacketParamWrapper;
import xyz.noark.core.ioc.wrap.param.PlayerIdParamWrapper;
import xyz.noark.core.ioc.wrap.param.SessionParamWrapper;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.Session;
import xyz.noark.reflectasm.MethodAccess;

public class PacketMethodWrapper
extends AbstractControllerMethodWrapper {
    private final Serializable opcode;
    private final boolean inner;
    private final Set<Session.State> stateSet;
    private final boolean allState;
    private final String queueId;
    private final ArrayList<ParamWrapper> parameters;
    private final LongAdder callNum = new LongAdder();

    public PacketMethodWrapper(MethodAccess methodAccess, Object single, PacketMethodDefinition md, ExecThreadGroup threadGroup, Class<?> controllerMasterClass, String queueId) {
        super(methodAccess, single, md.getMethodIndex(), threadGroup, controllerMasterClass.getName(), md.getOrder(), "protocol(opcode=" + md.getOpcode() + ")");
        this.opcode = md.getOpcode();
        this.inner = md.isInnerPacket();
        this.printLog = md.isPrintLog();
        this.stateSet = md.getStateSet();
        this.allState = this.stateSet.contains((Object)Session.State.ALL);
        this.deprecated = md.isDeprecated();
        this.queueId = queueId;
        this.parameters = new ArrayList(md.getParameters().length);
        Arrays.stream(md.getParameters()).forEach(this::buildParamWrapper);
    }

    private void buildParamWrapper(Parameter parameter) {
        if (Session.class.isAssignableFrom(parameter.getType())) {
            this.parameters.add(new SessionParamWrapper());
        } else if (parameter.isAnnotationPresent(PlayerId.class)) {
            this.parameters.add(new PlayerIdParamWrapper());
        } else if (parameter.getType().equals(byte[].class)) {
            this.parameters.add(new ByteArrayParamWrapper());
        } else if (NetworkPacket.class.isAssignableFrom(parameter.getType())) {
            this.parameters.add(new NetworkPacketParamWrapper());
        } else {
            this.parameters.add(new PacketParamWrapper(parameter.getType()));
        }
    }

    public Object[] analysisParam(Session session, NetworkPacket packet) {
        ArrayList<Object> args = new ArrayList<Object>(this.parameters.size());
        for (ParamWrapper parameter : this.parameters) {
            args.add(parameter.read(session, packet));
        }
        return args.toArray();
    }

    public Object[] analysisParam(Serializable playerId, Object protocol) {
        ArrayList<Object> args = new ArrayList<Object>(this.parameters.size());
        for (ParamWrapper parameter : this.parameters) {
            args.add(parameter.read(playerId, protocol));
        }
        return args.toArray();
    }

    public Serializable getOpcode() {
        return this.opcode;
    }

    public boolean isInner() {
        return this.inner;
    }

    public boolean isAllState() {
        return this.allState;
    }

    public Set<Session.State> getStateSet() {
        return this.stateSet;
    }

    public void incrCallNum() {
        this.callNum.increment();
    }

    public long getCallNum() {
        return this.callNum.longValue();
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }
}

