/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.manager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.log.LogHelper;

public class PacketMethodManager {
    private static final PacketMethodManager INSTANCE = new PacketMethodManager();
    private final ConcurrentMap<Serializable, PacketMethodWrapper> handlers = new ConcurrentHashMap<Serializable, PacketMethodWrapper>(2048);

    private PacketMethodManager() {
    }

    public static PacketMethodManager getInstance() {
        return INSTANCE;
    }

    public void resetPacketHandler(PacketMethodWrapper handler) {
        if (this.handlers.containsKey(handler.getOpcode())) {
            throw new ServerBootstrapException("\u91cd\u590d\u5b9a\u4e49\u7684 Opcode\uff1a" + handler.getOpcode());
        }
        this.handlers.put(handler.getOpcode(), handler);
    }

    public PacketMethodWrapper getPacketMethodWrapper(Serializable opcode) {
        return (PacketMethodWrapper)this.handlers.get(opcode);
    }

    public boolean temporarilyClosed(Serializable opcode) {
        PacketMethodWrapper method = this.getPacketMethodWrapper(opcode);
        if (method == null) {
            return false;
        }
        method.setDeprecated(true);
        return true;
    }

    public boolean temporaryOpening(Serializable opcode) {
        PacketMethodWrapper method = this.getPacketMethodWrapper(opcode);
        if (method == null) {
            return false;
        }
        method.setDeprecated(false);
        return true;
    }

    public void outputStatInfo(int maxSize) {
        HashMap result = new HashMap(this.handlers.size());
        for (Map.Entry e2 : this.handlers.entrySet()) {
            long num = ((PacketMethodWrapper)e2.getValue()).getCallNum();
            if (num <= 0L) continue;
            result.put(e2.getKey(), num);
        }
        result.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(maxSize).forEachOrdered(e -> LogHelper.logger.info("protocol stat. opcode={}, call={}", new Object[]{e.getKey(), e.getValue()}));
    }
}

