/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition.method;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import xyz.noark.core.annotation.controller.GetMapping;
import xyz.noark.core.annotation.controller.PostMapping;
import xyz.noark.core.annotation.controller.RequestMapping;
import xyz.noark.core.annotation.controller.RequestMethod;
import xyz.noark.core.annotation.controller.ResponseBody;
import xyz.noark.core.ioc.definition.method.SimpleMethodDefinition;
import xyz.noark.reflectasm.MethodAccess;

public class HttpMethodDefinition
extends SimpleMethodDefinition {
    private final String path;
    private final Set<RequestMethod> methodSet;
    private final String queueId;
    private final Parameter[] parameters;
    private final ResponseBody responseBody;

    public HttpMethodDefinition(MethodAccess methodAccess, Method method, RequestMapping requestMapping) {
        this(methodAccess, method, requestMapping.path(), requestMapping.method(), requestMapping.queueId());
    }

    public HttpMethodDefinition(MethodAccess methodAccess, Method method, GetMapping mapping) {
        this(methodAccess, method, mapping.path(), new RequestMethod[]{RequestMethod.GET}, mapping.queueId());
    }

    public HttpMethodDefinition(MethodAccess methodAccess, Method method, PostMapping mapping) {
        this(methodAccess, method, mapping.path(), new RequestMethod[]{RequestMethod.POST}, mapping.queueId());
    }

    private HttpMethodDefinition(MethodAccess methodAccess, Method method, String path, RequestMethod[] methods, String queueId) {
        super(methodAccess, method);
        this.path = path;
        this.methodSet = new HashSet<RequestMethod>(Arrays.asList(methods));
        this.queueId = queueId;
        this.parameters = method.getParameters();
        this.responseBody = method.getAnnotation(ResponseBody.class);
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    public ResponseBody getResponseBody() {
        return this.responseBody;
    }

    public String getPath() {
        return this.path;
    }

    public Set<RequestMethod> getMethodSet() {
        return this.methodSet;
    }

    public String getQueueId() {
        return this.queueId;
    }
}

